package com.mmc.oms.model.dto.coupon;

import cn.afterturn.easypoi.excel.annotation.ExcelTarget;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Author small
 * @Date 2023/5/24 14:09
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value="CouponUser对象", description="用户优惠券DTO表")
@ExcelTarget("couponUserExcel")
public class CouponUserDTO implements Serializable {

    private static final long serialVersionUID = 7665462964438044885L;
    @ApiModelProperty(value = "id")
    private Integer id;

    @ApiModelProperty(value = "优惠券id")
    private Integer couponId;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "订单id")
    private Long cid;

    @ApiModelProperty(value = "订单编码")
    private String orderNo;

    @ApiModelProperty(value = "领取人id")
    private Integer uid;

    @ApiModelProperty(value = "领取人uuid")
    private String uuid;

    @ApiModelProperty(value = "领取人手机号码")
    private String userPhone;

    @ApiModelProperty(value = "优惠券名称")
    private String couponName;

    @ApiModelProperty(value = "优惠券类型 1打折券, 2减免券 3无门槛")
    private Integer couponType;

    @ApiModelProperty(value = "优惠券使用类型 1vip券, 2品牌券")
    private Integer useType;

    @ApiModelProperty(value = "优惠券的面值")
    private BigDecimal couponMoney;

    @ApiModelProperty(value = "最低消费")
    private BigDecimal minPrice;

    @ApiModelProperty(value = "优惠券的折扣")
    private BigDecimal couponDiscount;

    @ApiModelProperty(value = "剩余余额")
    private BigDecimal remainingBalance;

    @ApiModelProperty(value = "获取方式，1 后台发放, 2 用户领取, 3赠送 4获赠")
    private String gainType;

    @ApiModelProperty(value = "状态（0：未使用,1：已使用, 2:已失效,3:已转赠,4:使用中）")
    private Integer status;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(value = "开始使用时间")
    private Date startTime;

    @ApiModelProperty(value = "过期时间")
    private Date endTime;

    @ApiModelProperty(value = "使用时间")
    private Date useTime;

    @ApiModelProperty(value = "所属品牌id")
    private String primaryKey;

    @ApiModelProperty(value = "兑换比例")
    private String conversionRatio;

    @ApiModelProperty(value = "转赠人uid")
    private String transferorUid;

    @ApiModelProperty(value = "获赠人uid")
    private String receiveUid;

    @ApiModelProperty(value = "转赠时间")
    private Date transferorTime;

    @ApiModelProperty(value = "是否多次核销 0单次核销 1多次核销")
    private Boolean verificationType;

    @ApiModelProperty(value = "最多优惠")
    private BigDecimal preferentialLimit;

    @ApiModelProperty(value = "所属品牌id")
    private List<String> brandIds;

    @ApiModelProperty(value = "可打折金额")
    private BigDecimal discountCouponPrice;

}
