package com.mmc.oms.feign;

import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.feign.hystrix.UserAppApiHystrix;
import com.mmc.oms.model.dto.ContractInfoDTO;
import com.mmc.oms.model.dto.uav.PayWalletDTO;
import com.mmc.oms.model.dto.user.UserAccountSimpleDTO;
import com.mmc.oms.model.qo.UserAccountQO;
import com.mmc.oms.model.vo.uav.PayUavWalletVO;
import com.mmc.oms.model.vo.wallet.TopUpOrderVO;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author: zj
 * @Date: 2023/5/18 17:06
 */
@FeignClient(url = "${userapp.url}", name = "cms-svc", fallback = UserAppApiHystrix.class)
public interface UserAppApi {
    @PostMapping("pay/feignTopUpCash")
    public ResultBody feignTopUpCash(@RequestBody TopUpOrderVO topUpOrderVO);

    @GetMapping("pay/getCurrentUserPayWalletInfo")
    public ResultBody<PayWalletDTO> getCurrentUserPayWalletInfo(@RequestHeader String token);

    @PostMapping("pay/feignPayUavWallet")
    public ResultBody feignPayUavWallet(@RequestBody PayUavWalletVO payUavWalletVO, @RequestHeader String token);

    @GetMapping("company/getManagerIdByBackUserId")
    public ResultBody getManagerIdByBackUserId(@RequestParam Integer backUserAccountId, @RequestHeader String token);

    /**
     * 获取小程序用户集合列表页面
     *
     * @param userAccountQO
     * @param token
     * @return
     */
    @PostMapping("user-account/feignListAppUserAccount")
    List<UserAccountSimpleDTO> feignListAppUserAccount(@ApiParam(value = "账号查询QO", required = true) @RequestBody UserAccountQO userAccountQO, @RequestHeader("token") String token);

    @PostMapping("/fdd/contract/listContractInfoByOrderNo")
    List<ContractInfoDTO> listContractInfoByOrderNo(@RequestBody List<String> orderNos, @RequestHeader("token") String token);

}
