package com.mmc.oms.common;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.read.listener.ReadListener;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author small
 * @Date 2023/5/24 15:37
 * @Version 1.0
 */
public final class EasyExcelListener<T> implements ReadListener<T>  {


    /**
     * 缓存的数据
     */
    private List<T> cachedDataList = new ArrayList<>();



    @Override
    @SuppressWarnings("unchecked")
    public void invoke(Object object, AnalysisContext analysisContext) {
        T map = (T) object;
        cachedDataList.add(map);
    }

    @Override
    public void doAfterAllAnalysed(AnalysisContext analysisContext) {

    }

    public List<T> getCachedDataList() {
        return cachedDataList;
    }

    public void setCachedDataList(List<T> cachedDataList){
        this.cachedDataList = cachedDataList;
    }

}
