package com.mmc.oms.model.vo.demand;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author small
 * @Date 2023/7/25 15:43
 * @Version 1.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class DemandReleaseOrderVO {
    private static final long serialVersionUID = -447951390213113317L;

    @ApiModelProperty(value = "需求发布id",required = true)
    private Integer requirementsInfoId;

    @ApiModelProperty(value = "需求类型id", example = "1", required = true)
    private Integer requirementTypeId;

    @ApiModelProperty(value = "任务标题", example = "任务标题001", required = true)
    private String taskTitle;

    @ApiModelProperty(value = "任务开始时间", example = "2023-07-25", required = true)
    private Date taskStartTime;

    @ApiModelProperty(value = "任务结束时间", example = "2023-07-26", required = true)
    private Date taskEndTime;

    @ApiModelProperty(value = "任务地址", example = "广东省深圳市", required = true)
    private String taskAddress;


    @ApiModelProperty(value = "任务经度", example = "23.344324", required = true)
    private Double longitude;

    @ApiModelProperty(value = "任务纬度", example = "44.344324", required = true)
    private Double latitude;

    @ApiModelProperty(value = "需求描述", example = "描述一下", required = true)
    private String requireDescription;

    @ApiModelProperty(value = "描述图片", example = "http://,http://", required = false)
    private String requireUrl;


    @ApiModelProperty(value = "发布者姓名", example = "张三")
    private String publishName;

    @ApiModelProperty(value = "发布者电话", example = "1892994543", required = true)
    private String publishPhone;

    @ApiModelProperty(value = "发布者id", example = "1", required = true)
    private Integer publishAccountId;

    /**
     * 后台获取token里面的用户id
     */
    @ApiModelProperty(value = "token用户id")
    private Integer userAccountId;

    @ApiModelProperty(value = "类型名称")
    private String requirementTypeName;

    @ApiModelProperty(value = "订单编号",example = "R202307251459553408130")
    private String orderNumber;

    @ApiModelProperty(value = "应支付金额 单位元", example = "1.00")
    private BigDecimal paramMoney;
}
