package com.mmc.oms.service.uav;

import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.model.dto.uav.UavOrderRemarkDTO;
import com.mmc.oms.model.dto.user.BaseAccountDTO;
import com.mmc.oms.model.qo.uav.UavOrderQO;
import com.mmc.oms.model.vo.uav.*;
import com.mmc.oms.model.vo.wallet.TopUpOrderVO;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author: zj
 * @Date: 2023/9/4 15:31
 */
public interface UavOrderService {
    ResultBody addOrder(AddUavOrderVO param, BaseAccountDTO currentAccount);

    ResultBody detail(Integer id, BaseAccountDTO baseAccountDTO) throws Exception;

    ResultBody close(Integer id, String token);

    ResultBody list(UavOrderQO uavOrderQO, BaseAccountDTO currentAccount);

    ResultBody listByUid(UavOrderQO uavOrderQO, BaseAccountDTO currentAccount);

    ResultBody pay(Integer id, BaseAccountDTO currentAccount, HttpServletRequest request);

    ResultBody send(UavOrderExpressVO param);

    ResultBody receive(Integer id, BaseAccountDTO currentAccount);

    ResultBody remarkOrder(UavOrderRemarkVO uavOrderRemarkVO);

    ResultBody sellerRemark(Integer id, String content);

    ResultBody statusList();

    ResultBody upLoadPay(UavOrderPayVO uavOrderPayVO);

    ResultBody checkPay(UavOrderPayVO uavOrderPayVO);

    void payUavOrder(TopUpOrderVO topUpOrderVO);

    ResultBody confirmOrder(UavOrderVO uavOrderVO, BaseAccountDTO currentAccount);

    ResultBody checkNoReceive();

    ResultBody uavOrderFinishSign(String orderNo);

    ResultBody removeUavOrder(Integer id);

    ResultBody addOrderByCart(AddUavOrderByCartQO orderByCartQO, BaseAccountDTO currentAccount);


    ResultBody deductWallet(BigDecimal allShareAmount, BigDecimal allSalaryAmount, BaseAccountDTO currentAccount);

    List<UavOrderRemarkDTO> listGoodsRemark(Integer remarkType, Integer goodsId);
}
