package com.mmc.oms.model.vo.order;

import com.mmc.oms.common.publicinterface.Create;
import com.mmc.oms.common.publicinterface.Insert;
import com.mmc.oms.common.publicinterface.Update;
import com.mmc.oms.model.qo.BaseInfoQO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author small
 * @Date 2023/5/31 16:50
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "分页管理查询对象")
public class TagInfoAllotVO extends BaseInfoQO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "id标识")
    @NotNull(message = "id不能为空", groups = {Update.class})
    private Integer id;

    @ApiModelProperty(value = "标签名称")
    @NotBlank(message = "名称不能为空", groups = {Create.class, Update.class, Insert.class})
    @Length(max = 70, message = "名称不能超过70个字符", groups = {Create.class, Update.class,})
    private String tagName;

    @ApiModelProperty(value = "分成比例")
    @Min(value = 0, message = "分成比例不能为负", groups = {Create.class, Update.class})
    @Max(value = 100, message = "分成比例不能大于100", groups = {Create.class, Update.class})
    private BigDecimal proportion;

    @ApiModelProperty(value = "上级分成比例")
    @Min(value = 0, message = "分成比例不能为负", groups = {Create.class, Update.class})
    @Max(value = 100, message = "分成比例不能大于100", groups = {Create.class, Update.class})
    private BigDecimal supProportion;

    @ApiModelProperty(value = "结算时间")
    @Min(value = 1, message = "结算时间不能少于1号", groups = {Create.class, Update.class})
    @Max(value = 31, message = "结算时间不能大于31号", groups = {Create.class, Update.class})
    private Integer balanceDate;

    @ApiModelProperty(value = "提现费率")
    @Min(value = 0, message = "分成比例不能为负", groups = {Create.class, Update.class})
    @Max(value = 100, message = "分成比例不能大于100", groups = {Create.class, Update.class})
    private BigDecimal extractRatio;

    /**
     * 传入数据库为小数值
     */
    public TagInfoAllotVO convertDecimals() {
        this.proportion = this.proportion == null ? null : this.proportion.divide(new BigDecimal("100"), 5, BigDecimal.ROUND_DOWN);
        this.supProportion = this.supProportion == null ? null : this.supProportion.divide(new BigDecimal("100"), 5, BigDecimal.ROUND_DOWN);
        this.extractRatio = this.extractRatio == null ? null : this.extractRatio.divide(new BigDecimal("100"), 5, BigDecimal.ROUND_DOWN);
        return this;
    }
}

