package com.mmc.oms.model.excel;

import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelTarget;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * author:zhenjie
 * Date:2022/11/9
 * time:16:21
 */
@Data
@NoArgsConstructor
@ExcelTarget("shoppingTrolleyProdExcel")
public class ShoppingTrolleyProdExcel implements Serializable {
    private static final long serialVersionUID = 7448834330533651658L;

    private Integer productSpecId;

    @Excel(name = "产品名称", orderNum = "1", width = 25)
    private String productName;

    @Excel(name = "所选规格", orderNum = "2", width = 25)
    private String productSpecName;

    @Excel(name = "数量", orderNum = "3", width = 25)
    private Integer buyNum;

    @Excel(name = "单位", orderNum = "4", width = 25)
    private String unit;

    @Excel(name = "产品图片", orderNum = "5", width = 15, height = 30, type = 2)
    private String productSpecImg;

    @Excel(name = "合作价格", orderNum = "6", width = 25, numFormat = "¥#,##0.00;¥-#,##0.00")
    private BigDecimal opPrice;

    @Excel(name = "市场指导价格", orderNum = "7", width = 25, numFormat = "¥#,##0.00;¥-#,##0.00")
    private BigDecimal mkPrice;
}
