package com.mmc.oms.feign;

import com.mmc.oms.model.dto.mall.CooperationTagVO;
import com.mmc.oms.model.dto.user.UserAccountSimpleDTO;
import com.mmc.oms.model.qo.mall.BUserAccountQO;
//import io.swagger.annotations.ApiParam;
//import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author: zj
 * @Date: 2023/5/18 17:06
 */
//@FeignClient(url = "${userapp.url}", name = "cms-svc", fallback = UserAppApiHystrix.class)
public interface UserAppApi {
    /**
     * 根据用户id获取基本信息
     * @param userAccountId
     * @return
     */
    @RequestMapping(value = "user-account/feignGetUserSimpleInfo", method = RequestMethod.GET)
    public UserAccountSimpleDTO feignGetUserSimpleInfo(@RequestParam Integer userAccountId, @RequestHeader("token") String token);

    /**
     * 根据地区信息查询用户id
     * @param provinceCode
     * @param cityCode
     * @param districtCode
     * @return
     */
    @GetMapping("user-account/feignListUserAccountIds")
    List<Integer> feignListUserAccountIds(@RequestParam Integer provinceCode, @RequestParam(required = false) Integer cityCode,
                                          @RequestParam(required = false) Integer districtCode, @RequestHeader(value = "token", required = false) String token);


    /**
     * 获取用户集合列表页面
     *
     * @param bUserAccountQO 问:b用户帐户
     * @return {@link List}<{@link UserAccountSimpleDTO}>
     */
    @PostMapping("back-user/feignListBAccountPage")
    List<UserAccountSimpleDTO> feignListBAccountPage( @RequestBody BUserAccountQO bUserAccountQO, @RequestHeader("token") String token);

    /**
     * 根据用户id查询用户信息
     * @param ids
     * @param token
     * @return
     */
    @PostMapping("user-account/feignListUserAccountByIds")
    List<UserAccountSimpleDTO> feignListUserAccountByIds(@RequestBody List<Integer> ids, @RequestHeader("token") String token);

    /**
     * 查询推荐人信息
     * @param userIds
     * @return
     */
    @PostMapping("user-account/feignListRcdUserInfo")
    List<UserAccountSimpleDTO> feignListRcdUserInfo(@RequestBody List<Integer> userIds);

    /**
     * 查询上级id
     * @param userAccountId
     * @return
     */
    @GetMapping("user-account/feignGetSuperiorRef")
    Integer feignGetSuperiorRef(@RequestParam Integer userAccountId);

    /**
     * 查询上级推荐人信息
     * @param userAccountId
     * @return
     */
    @GetMapping("user-account/feignGetUserRcdInfo")
    UserAccountSimpleDTO feignGetUserRcdInfo(@RequestParam Integer userAccountId);

    /**
     * 用户合作标签
     * @return
     */
    @GetMapping("cooperation/feignListCooperationTag")
    List<CooperationTagVO> feignListCooperationTag();

}
