package com.mmc.oms.model.vo.coupon;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author small
 * @Date 2023/6/5 13:58
 * @Version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class RedEnvelopeVO implements Serializable {
    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "用户范围（1所有用户 2渠道用户 3非渠道用户 4注册用户）", required = true, example = "1")
    @NotBlank(message = "用户范围")
    private Integer userScope;

    @ApiModelProperty(value = "优惠券名称", required = true, example = "123")
    @NotBlank(message = "请填写优惠券名称")
    @Length(max = 64, message = "优惠券名称长度不能超过64个字符")
    private String couponName;

    @ApiModelProperty(value = "分享者-优惠券使用类型 1vip券, 2品牌券 3红包", required = true, example = "3")
    @Range(min = 1, max = 2, message = "请选择优惠券使用类型")
    private Integer useType;


    @ApiModelProperty(value = "分享者-可使用时间范围 开始时间 yyyy-MM-dd HH:mm:ss", required = true, example = "2023-06-05 00:00:00")
    private Date useStartTime;

    @ApiModelProperty(value = "分享者-可使用时间范围 结束时间 yyyy-MM-dd HH:mm:ss", required = true, example = "2023-07-07 23:59:59")
    private Date useEndTime;

    @ApiModelProperty(value = "分享者-兑换的优惠券面值", required = true, example = "100")
    @NotNull(message = "红包金额")
    @DecimalMax(value = "99999.99", message = "优惠券面值不能大于99999.99")
    private BigDecimal couponMoney;


    @ApiModelProperty(value = "分享者-发放总数", required = true, example = "10")
    private Integer couponTotal;

    @ApiModelProperty(value = "分享者-分享人数", required = true, example = "2")
    private Integer peopleNumber;

    @ApiModelProperty(value = "被分享用户标签  1新人 2实名认证 3企业认证 4 无", example = "4")
    private Integer userTag;


    @ApiModelProperty(value = "被分享者-优惠券使用类型 1vip,2品牌券 3红包", required = true, example = "3")
    @Range(min = 1, max = 2, message = "请选择优惠券使用类型")
    private Integer beSharedUseType;

    @ApiModelProperty(value = "被分享者-兑换的优惠券面值", required = true, example = "50")
    @NotNull(message = "红包金额")
    @DecimalMax(value = "99999.99", message = "优惠券面值不能大于99999.99")
    private BigDecimal beSharedCouponMoney;


    @ApiModelProperty(value = "被分享者-发放总数", required = true, example = "12")
    private Integer beSharedCouponTotal;


}
