package com.mmc.oms.model.qo;

import com.mmc.oms.common.publicinterface.Page;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class GeneralQO {
    @ApiModelProperty(value = "页码", required = true, example = "1")
    @NotNull(
            message = "页码不能为空",
            groups = {Page.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;

    @ApiModelProperty(value = "每页显示数", required = true, example = "10")
    @NotNull(
            message = "每页显示数不能为空",
            groups = {Page.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;

    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }
}
