package com.mmc.oms.common;

import lombok.Data;

import java.io.Serializable;

/**
 * @Author small
 * @Date 2023/5/28 17:32
 * @Version 1.0
 */
@Data
public class Tenant implements Serializable {

    /**
     * 用户id
     */
    private Integer userId;
    /**
     * 所在机构id
     */
    private Integer tenantId;
    /**
     * 用户名称
     */
    private String userName;
    /**
     * 管理机构id集合
     */
    private String tenantIds;
    /**
     * 菜单路由路径集合
     */
    private String token;
    /**
     * 角色id
     */
    private Integer roleId;

    /**
     * 角色类型，1超管  2其他角色
     */
    private Integer roleType;

    public Tenant(String userName) {
        this.userId = userId;
        this.tenantId = tenantId;
        this.userName = userName;
        this.tenantIds = tenantIds;
        this.token = token;
        this.roleId = roleId;
        this.roleType = roleType;
    }

    /**
     * userid相同，认为是同个用户
     *
     * @param o
     * @return
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Tenant) {
            Tenant tenant = (Tenant) o;
            return getUserId().equals(tenant.getUserId());
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 31 * result + getUserId().hashCode();
        return result;
    }
}
