package com.mmc.oms.feign.hystrix;

import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.feign.UserAppApi;
import com.mmc.oms.model.vo.wallet.TopUpOrderVO;
import lombok.extern.slf4j.Slf4j;

/**
 * @author: zj
 * @Date: 2023/5/18 17:08
 */
@Slf4j
public class UserAppApiHystrix implements UserAppApi {

    @Override
    public ResultBody feignTopUpCash(TopUpOrderVO topUpOrderVO) {
        log.error("熔断：UserAppApiHystrix.feignTopUpCash==error==>param:{}", topUpOrderVO);
        return ResultBody.error("-1", "远程调用失败");
    }
}
