package com.mmc.oms.feign;

import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.feign.hystrix.UserAppApiHystrix;
import com.mmc.oms.model.vo.wallet.TopUpOrderVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author: zj
 * @Date: 2023/5/18 17:06
 */
@FeignClient(url = "${userapp.url}", name = "cms-svc", fallback = UserAppApiHystrix.class)
public interface UserAppApi {
    @PostMapping("pay/feignTopUpCash")
    public ResultBody feignTopUpCash(@RequestBody TopUpOrderVO topUpOrderVO);

}
