package com.mmc.oms.service.mall.impl;

import com.mmc.oms.common.result.PageResult;
import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.dao.mall.PointsMallDao;
import com.mmc.oms.dao.mall.PointsOrderDao;
import com.mmc.oms.entity.mall.PointsMallDO;
import com.mmc.oms.model.qo.GeneralQO;
import com.mmc.oms.service.mall.PointMallService;
import lombok.AllArgsConstructor;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author Admin
 */
@Service
@Slf4j
@Transactional(rollbackFor = Exception.class)
@AllArgsConstructor
public class PointsMallServiceImpl implements PointMallService {
    private PointsMallDao pointsMallDao;
    private PointsOrderDao pointsOrderDao;


    @Override
    public ResultBody insertMall(PointsMallDO pointsMallDO) {
        pointsMallDao.insert(pointsMallDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody updateMall(PointsMallDO pointsMallDO) {
        pointsMallDao.updateByPrimaryKeySelective(pointsMallDO);
        return ResultBody.success();
    }

    /**
     * 获取积分商品详情
     *
     * @param id
     * @return {@link ResultBody}
     */
    @Override
    public ResultBody getMallInfo(Integer id) {
        PointsMallDO pointsMallDO = pointsMallDao.selectByPrimaryKey(id);
        return ResultBody.success(pointsMallDO);
    }

    /**
     * 获取积分商品列表
     *
     * @param qo 参数
     * @return {@link ResultBody}
     */
    @Override
    public ResultBody getMallList(GeneralQO qo) {
        qo.buildCurrentPage();
        List<PointsMallDO> pointsMallDOS = pointsMallDao.selectAll(qo);
        int count = pointsMallDao.count();
        return ResultBody.success(PageResult.buildPage(qo.getPageNo(),qo.getPageSize(),count,pointsMallDOS));
    }
}
