package com.mmc.oms.feign.hystrix;

import com.alibaba.fastjson2.JSONObject;
import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.feign.UserAppApi;
import com.mmc.oms.model.dto.ContractInfoDTO;
import com.mmc.oms.model.dto.uav.PayWalletDTO;
import com.mmc.oms.model.dto.user.UserAccountSimpleDTO;
import com.mmc.oms.model.qo.UserAccountQO;
import com.mmc.oms.model.qo.mall.BUserAccountQO;
import com.mmc.oms.model.vo.uav.PayUavWalletVO;
import com.mmc.oms.model.vo.wallet.TopUpOrderVO;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

/**
 * @author: zj
 * @Date: 2023/5/18 17:08
 */
@Slf4j
public class UserAppApiHystrix implements UserAppApi {

    @Override
    public ResultBody feignTopUpCash(TopUpOrderVO topUpOrderVO) {
        log.error("熔断：UserAppApiHystrix.feignTopUpCash==error==>param:{}", topUpOrderVO);
        return ResultBody.error("-1", "远程调用失败");
    }

    @Override
    public ResultBody<PayWalletDTO> getCurrentUserPayWalletInfo(String token) {
        log.error("熔断：UserAppApiHystrix.getCurrentUserPayWalletInfo==error");
        return ResultBody.error("-1", "远程调用失败");
    }

    @Override
    public ResultBody<PayWalletDTO> getPayWalletInfo(Integer userAccountId, String token) {
        log.error("熔断：UserAppApiHystrix.getPayWalletInfo==error");
        return ResultBody.error("-1", "远程调用失败");
    }

    @Override
    public ResultBody feignPayUavWallet(PayUavWalletVO payUavWalletVO, String token) {
        log.error("熔断：UserAppApiHystrix.feignPayUavWallet==error==>param:{}", JSONObject.toJSONString(payUavWalletVO));
        return ResultBody.error("-1", "远程调用失败");
    }

    @Override
    public ResultBody getManagerIdByBackUserId(Integer backUserAccountId, String token) {
        log.error("熔断：UserAppApiHystrix.getManagerIdByBackUserId==error==>param:{}", JSONObject.toJSONString(backUserAccountId));
        return ResultBody.error("-1", "远程调用失败");
    }

    @Override
    public List<UserAccountSimpleDTO> feignListUserAccountByIds(List<Integer> ids, String token) {
        log.error("熔断：UserAppApiHystrix.feignListUserAccountByIds：{}", ids);
        return null;
    }

    @Override
    public List<UserAccountSimpleDTO> feignListAppUserAccount(UserAccountQO userAccountQO, String token) {
        log.error("熔断：UserAppApiHystrix.feignListAppUserAccount：{}", userAccountQO);
        return null;
    }

    @Override
    public List<ContractInfoDTO> listContractInfoByOrderNo(List<String> orderNos, String token) {
        log.error("熔断：UserAppApiHystrix.listContractInfoByOrderNo==error==>param:{}", JSONObject.toJSONString(orderNos));
        return null;
    }

    @Override
    public UserAccountSimpleDTO feignGetUserSimpleInfo(Integer userAccountId, String token) {
        log.error("熔断：UserAppApiHystrix.feignGetUserSimpleInfo==error==>param:{}", JSONObject.toJSONString(userAccountId));
        return null;
    }

    @Override
    public List<UserAccountSimpleDTO> feignListBAccountPage(BUserAccountQO bUserAccountQO, String token) {
        log.error("熔断：UserAppApiHystrix.feignListBAccountPage==error==>param:{}", JSONObject.toJSONString(bUserAccountQO));
        return null;
    }
}
