package com.mmc.oms.entity.uav;

import com.mmc.oms.model.dto.uav.UavOrderRemarkDTO;
import com.mmc.oms.model.vo.uav.UavOrderRemarkVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/9/9 17:48
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("最新版-订单评价信息")
public class UavOrderRemarkDO implements Serializable {
    private static final long serialVersionUID = 3316555339556069007L;
    @ApiModelProperty(value = "评价id")
    private Integer id;
    @ApiModelProperty(value = "评价类型，0商城，1租赁")
    private Integer remarkType;
    @ApiModelProperty(value = "商品id")
    private Integer mallGoodsId;
    @ApiModelProperty(value = "订单id")
    private Integer uavOrderId;
    @ApiModelProperty(value = "评分")
    private Integer remarkLevel;
    @ApiModelProperty(value = "图片地址，‘，’隔开")
    private String uavImages;
    @ApiModelProperty(value = "评论内容")
    private String content;
    @ApiModelProperty(value = "生成时间")
    private Date createTime;

    public UavOrderRemarkDTO buildUavOrderRemarkDTO() {
        return UavOrderRemarkDTO.builder().id(this.id).remarkType(this.remarkType).mallGoodsId(this.mallGoodsId)
                .uavOrderId(this.uavOrderId).remarkLevel(this.remarkLevel).content(this.content).uavImages(this.uavImages)
                .createTime(this.createTime).build();
    }

    public UavOrderRemarkDO(UavOrderRemarkVO uavOrderRemarkVO){
        this.id = uavOrderRemarkVO.getId();
        this.mallGoodsId = uavOrderRemarkVO.getMallGoodsId();
        this.uavOrderId = uavOrderRemarkVO.getUavOrderId();
        this.remarkLevel = uavOrderRemarkVO.getRemarkLevel();
        this.uavImages = uavOrderRemarkVO.getUavImages();
        this.content = uavOrderRemarkVO.getContent();
    }
}
