package com.mmc.oms.controller.mall;

import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.entity.mall.PointsMallDO;
import com.mmc.oms.model.dto.mall.MallOrderPageDTO;
import com.mmc.oms.model.qo.GeneralQO;
import com.mmc.oms.model.qo.mall.MallOrderQO;
import com.mmc.oms.service.mall.MallOrderService;
import com.mmc.oms.service.mall.PointMallService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import lombok.AllArgsConstructor;
import lombok.NoArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @author Admin
 */
@Api(tags = { "积分商城(订单)" })
@RestController
@RequestMapping("/pointsMall/")
@AllArgsConstructor
public class PointsMallController {

    private final PointMallService pointMallService;

    @ApiOperation(value = "后台——添加积分商品")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @PostMapping("insertMall")
    public ResultBody insertMall(@RequestBody PointsMallDO param, HttpServletRequest request) {
        return pointMallService.insertMall(param);
    }
    @ApiOperation(value = "后台——修改积分商品")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @PostMapping("updateMall")
    public ResultBody updateMall(@RequestBody PointsMallDO param, HttpServletRequest request) {
        return pointMallService.updateMall(param);
    }

    @ApiOperation(value = "积分商品详情")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @GetMapping("getMallInfo")
    public ResultBody getMallInfo(@RequestParam("id") Integer id, HttpServletRequest request) {
        return pointMallService.getMallInfo(id);
    }
    @ApiOperation(value = "积分商城列表")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @PostMapping("getMallList")
    public ResultBody getMallList(@RequestBody GeneralQO qo, HttpServletRequest request) {
        return pointMallService.getMallList(qo);
    }



}
