package com.mmc.oms.model.dto.mall;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * author:zhenjie
 * Date:2023/4/26
 * time:14:32
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "com.mmc.csf.mall.dto.MallOrderFinishDTO", description = "无人机城完成状态的订单")
public class MallOrderFinishDTO implements Serializable {
    private static final long serialVersionUID = 4577011678089794859L;
    @ApiModelProperty("订单id")
    private Integer orderId;

    @ApiModelProperty("订单编号")
    private String orderNo;

    @ApiModelProperty("订单名称")
    private String orderName;

    @ApiModelProperty("实付金额(订单价格-优惠券金额-手动折扣)0406")
    private BigDecimal realityAmount;

    @ApiModelProperty("是否已分成")
    private Integer divide;

    @ApiModelProperty("用户id")
    private Integer userAccountId;

    @ApiModelProperty("买家uid")
    private String uid;

    @ApiModelProperty("买家姓名")
    private String userName;

    @ApiModelProperty("买家昵称")
    private String nickName;

    @ApiModelProperty(value = "认证企业")
    private String entName;

}
