package com.mmc.oms.controller;

import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.model.vo.order.OrderRefundVO;
import com.mmc.oms.model.vo.order.RefundYesOrNoVO;
import com.mmc.oms.service.OrderRefundService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

/**
 * @Author small
 * @Date 2023/6/1 16:02
 * @Version 1.0
 */
@Api(tags = {"订单-退款相关-接口"})
@RestController
@RequestMapping("/refund/")
public class OrderRefundController extends BaseController {


    @Autowired
    private OrderRefundService orderRefundService;


    @ApiOperation(value = "web/小程序——发起退款申请")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("applyRetreat")
    public ResultBody applyRetreat(HttpServletRequest request, @RequestBody OrderRefundVO param) {
        return orderRefundService.applyRetreat(this.getCurrentAccount(request), param);
    }

    @ApiOperation(value = "后台管理——驳回/同意退款")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("refund")
    public ResultBody refund(HttpServletRequest request, @RequestBody RefundYesOrNoVO param) {
        return orderRefundService.refund(this.getCurrentAccount(request), param);
    }


}
