package com.mmc.oms.service.Impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.mmc.oms.common.EasyExcelListener;
import com.mmc.oms.common.coupon.CouponConstants;
import com.mmc.oms.common.coupon.CouponUserExcel;
import com.mmc.oms.common.result.PageResult;
import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.common.util.TDateUtil;
import com.mmc.oms.dao.CouponBackDao;
import com.mmc.oms.dao.CouponUserDao;
import com.mmc.oms.entity.coupon.ChannelCouponDO;
import com.mmc.oms.entity.coupon.CouponDO;
import com.mmc.oms.entity.coupon.CouponUserDO;
import com.mmc.oms.entity.order.ProductInformationDo;
import com.mmc.oms.model.dto.coupon.CouponActivityDTO;
import com.mmc.oms.model.dto.coupon.CouponDTO;
import com.mmc.oms.model.dto.coupon.CouponUserDTO;
import com.mmc.oms.model.dto.coupon.CouponViewDTO;
import com.mmc.oms.model.dto.user.MallUserDTO;
import com.mmc.oms.model.qo.CouponInfoQO;
import com.mmc.oms.model.qo.CouponUserInfoQO;
import com.mmc.oms.model.qo.ProductCouponQO;
import com.mmc.oms.model.vo.coupon.CouponInfoActivityVO;
import com.mmc.oms.model.vo.coupon.CouponInfoVO;
import com.mmc.oms.model.vo.coupon.RedEnvelopeVO;
import com.mmc.oms.service.CouponBackService;
import com.mmc.oms.service.CouponUserService;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Author small
 * @Date 2023/5/24 14:42
 * @Version 1.0
 */
@Service
public class CouponBackServiceImpl extends ServiceImpl<CouponBackDao, CouponDO> implements CouponBackService {

    @Resource
    private CouponUserService couponUserService;

    //@Autowired
    //private MallUserClient mallUserClient;

    //@Autowired
    //private MallOrderClient mallOrderClient;

    @Autowired
    private TransactionTemplate transactionTemplate;

    @Resource
    private CouponUserDao couponUserDao;

    @Resource
    private CouponBackDao couponBackDao;


    @Override
    public ResultBody saveCouponBackInfo(CouponInfoVO couponVO, MultipartFile file) {
        LambdaQueryWrapper<CouponDO> wrapper = new LambdaQueryWrapper();
        wrapper.eq(CouponDO::getCouponName, couponVO.getCouponName()).eq(CouponDO::getIsDel, false);
        long count = this.count(wrapper);
        if (count > 0) {
            return ResultBody.error("优惠券名重复");
        }
        if (CouponConstants.COUPON_TYPE_REDUCED.equals(couponVO.getCouponType())) {
            int flag = couponVO.getMinPrice().compareTo(couponVO.getCouponMoney());
            if (flag < 0) {
                return ResultBody.error("优惠券最低消费不能小于面值");
            }
        }

        CouponDO couponDO = new CouponDO(couponVO);
        couponDO.setLastTotal(couponVO.getCouponTotal());
        couponDO.setCreateTime(new Date());

        boolean save = this.save(couponDO);
        CouponDTO couponDTO = couponDO.bilIdCouponDTO();

        //批量导入用户
        if (file != null) {
            List<ChannelCouponDO> channelCouponDOS = redeExcel(file);
            List<String> uid = new ArrayList<>();
            List<String> phone = new ArrayList<>();
            for (ChannelCouponDO channelCouponDO : channelCouponDOS) {
                if (StringUtils.isNotBlank(channelCouponDO.getUid())) {
                    uid.add(channelCouponDO.getUid());
                } else {
                    phone.add(channelCouponDO.getUserPhone());
                }
            }

            //远程调用 批量查询用户信息
            List<MallUserDTO> mallUserDTOS = null;
            //mallUserClient.feignGetListUserDTO(uid, phone);
            if (mallUserDTOS != null && mallUserDTOS.size() > 0) {
                //查看当前优惠券剩余量
                if (couponDO.getIsLimited() && couponDO.getLastTotal() < mallUserDTOS.size()) {
                    return ResultBody.error("当前剩余量不够领取");
                }
                List<CouponUserDO> couponUserList = extracted(couponDO, mallUserDTOS);

                Boolean execute = transactionTemplate.execute(e -> {
                    couponUserService.saveBatch(couponUserList);
                    //扣减数量
                    deduction(couponDO.getId(), couponUserList.size(), couponDO.getIsLimited());
                    return Boolean.TRUE;
                });
            }
        }

        if (save) {
            return ResultBody.success(couponDTO);
        } else {
            return ResultBody.error("请稍后重试");
        }

    }

    @Override
    public ResultBody saveActivityCouponInfo(CouponInfoActivityVO couponInfoActivityVO) {
        LambdaQueryWrapper<CouponDO> wrapper = new LambdaQueryWrapper();
        wrapper.eq(CouponDO::getCouponName, couponInfoActivityVO.getCouponName()).eq(CouponDO::getIsDel, false);
        long count = this.count(wrapper);
        if (count > 0) {
            return ResultBody.error("优惠券名重复");
        }
        if (CouponConstants.COUPON_TYPE_REDUCED.equals(couponInfoActivityVO.getCouponType()) ||
                CouponConstants.COUPON_TYPE_REDUCED.equals(couponInfoActivityVO.getBeSharedCouponType())) {
            int flag = couponInfoActivityVO.getMinPrice().compareTo(couponInfoActivityVO.getCouponMoney());
            int i = couponInfoActivityVO.getBeSharedMinPrice().compareTo(couponInfoActivityVO.getBeSharedCouponMoney());
            if (flag < 0 || i < 0) {
                return ResultBody.error("优惠券最低消费不能小于面值");
            }

        }
        if (couponInfoActivityVO.getBeSharedCouponTotal() < couponInfoActivityVO.getCouponTotal()) {
            return ResultBody.error("被分享者券发行量应大于等于分享者券发行量*分享人数*1.5");
        }
        CouponDO couponDO = new CouponDO(couponInfoActivityVO);
        couponDO.setLastTotal(couponInfoActivityVO.getCouponTotal());
        couponDO.setCreateTime(new Date());
        couponDO.setIsLimited(true);
        CouponDO couponActivity = new CouponDO(couponInfoActivityVO, 1);
        couponActivity.setLastTotal(couponInfoActivityVO.getBeSharedCouponTotal());
        couponActivity.setCreateTime(new Date());
        Boolean execute = transactionTemplate.execute(e -> {
            this.save(couponDO);
            couponActivity.setParentId(couponDO.getId());
            this.save(couponActivity);
            return Boolean.TRUE;
        });
        if (execute) {
            return ResultBody.success();
        } else {
            return ResultBody.error("请稍后重试");
        }
    }


    @Override
    public ResultBody redEnvelope(RedEnvelopeVO redEnvelopeVO) {
        LambdaQueryWrapper<CouponDO> wrapper = new LambdaQueryWrapper();
        wrapper.eq(CouponDO::getCouponName, redEnvelopeVO.getCouponName()).eq(CouponDO::getIsDel, false);
        long count = this.count(wrapper);
        if (count > 0) {
            return ResultBody.error("优惠券名重复");
        }
        if (redEnvelopeVO.getBeSharedCouponTotal() < redEnvelopeVO.getCouponTotal()) {
            return ResultBody.error("被分享者券发行量应大于等于分享者券发行量*分享人数*1.5");
        }
        CouponDO couponDO = new CouponDO(redEnvelopeVO);
        couponDO.setLastTotal(redEnvelopeVO.getCouponTotal());
        couponDO.setCreateTime(new Date());
        couponDO.setIsLimited(true);
        CouponDO couponActivity = new CouponDO(redEnvelopeVO, 1);
        couponActivity.setLastTotal(redEnvelopeVO.getBeSharedCouponTotal());
        couponActivity.setCreateTime(new Date());
        Boolean execute = transactionTemplate.execute(e -> {
            this.save(couponDO);
            couponActivity.setParentId(couponDO.getId());
            this.save(couponActivity);
            return Boolean.TRUE;
        });
        if (execute) {
            return ResultBody.success();
        } else {
            return ResultBody.error("请稍后重试");
        }
    }

    private List<CouponUserDO> extracted(CouponDO couponDO, List<MallUserDTO> result) {
        Integer couponDay = couponDO.getCouponDay();
        DateTime date = DateUtil.date();

        List<CouponUserDO> couponUserList = new ArrayList<>();

        //优惠券有效期使用时间
        if (CouponConstants.COUPON_USE_TIME_THE_DAY.equals(couponDO.getIsFixedTime())) {
            //领取当日起
            couponDO.setUseStartTime(date);
            couponDO.setUseEndTime(DateUtil.offsetDay(date, couponDay));
        } else if (CouponConstants.COUPON_USE_TIME_NEXT_DAY.equals(couponDO.getIsFixedTime())) {
            //领取次日起
            DateTime dateTime = DateUtil.offsetDay(date, 1);
            couponDO.setUseStartTime(dateTime);
            couponDO.setUseEndTime(DateUtil.offsetDay(dateTime, couponDay));
        } else {
            couponDO.setUseStartTime(couponDO.getUseStartTime());
            couponDO.setUseEndTime(couponDO.getUseEndTime());
        }
        Integer restrictedAccess = couponDO.getRestrictedAccess();

        for (int i = 0; i < result.size(); i++) {
            for (Integer integer = 0; integer < restrictedAccess; integer++) {
                CouponUserDO couponUserDO = new CouponUserDO(couponDO);
                couponUserDO.setGainType(CouponConstants.STORE_COUPON_USER_TYPE_SEND);
                couponUserDO.setCreateTime(date);
                MallUserDTO mallUserDTO = result.get(i);
                couponUserDO.setUid(mallUserDTO.getId());
                couponUserDO.setUuid(mallUserDTO.getUid());
                couponUserDO.setUserPhone(mallUserDTO.getPhoneNum());
                couponUserList.add(couponUserDO);
            }
        }

        return couponUserList;
    }

    @Override
    public ResultBody pageCouponList(CouponInfoQO couponInfoQO) {
        LambdaQueryWrapper<CouponDO> queryWrapper = new LambdaQueryWrapper<>();
        if (StringUtils.isNotBlank(couponInfoQO.getCouponName())) {
            queryWrapper.like(CouponDO::getCouponName, couponInfoQO.getCouponName());
        }
        if (StringUtils.isNotBlank(couponInfoQO.getCouponId())) {
            queryWrapper.like(CouponDO::getId, couponInfoQO.getCouponId());
        }
        if (couponInfoQO.getState() != null) {
            queryWrapper.eq(CouponDO::getCouponStatus, couponInfoQO.getState());
        }
        if (StringUtils.isNotBlank(couponInfoQO.getStartTime())) {
            queryWrapper.ge(CouponDO::getCreateTime, couponInfoQO.getStartTime());
        }
        if (StringUtils.isNotBlank(couponInfoQO.getEndTime())) {
            queryWrapper.le(CouponDO::getCreateTime, couponInfoQO.getEndTime());
        }

        queryWrapper.eq(CouponDO::getIsDel, false);
        queryWrapper.eq(CouponDO::getUseType, couponInfoQO.getUseType());
        queryWrapper.orderByDesc(CouponDO::getCreateTime);
        Page<CouponDO> pages = new Page<>(couponInfoQO.getPageNo(), couponInfoQO.getPageSize());
        Page<CouponDO> pageInfo = this.page(pages, queryWrapper);

        List<CouponDTO> collect = pageInfo.getRecords().stream().map(CouponDO::bilIdCouponDTO)
                .collect(Collectors.toList());

        PageResult pageResult = PageResult.buildPage(couponInfoQO.getPageNo(), couponInfoQO.getPageSize(),
                (int) pageInfo.getTotal(), collect);
        return ResultBody.success(pageResult);
    }


    @Override
    public ResultBody pageActivityCouponList(CouponInfoQO couponInfoQO) {
        LambdaQueryWrapper<CouponDO> queryWrapper = new LambdaQueryWrapper<>();
        if (StringUtils.isNotBlank(couponInfoQO.getCouponName())) {
            queryWrapper.like(CouponDO::getCouponName, couponInfoQO.getCouponName());
        }
        if (StringUtils.isNotBlank(couponInfoQO.getCouponId())) {
            queryWrapper.like(CouponDO::getId, couponInfoQO.getCouponId());
        }
        if (couponInfoQO.getState() != null) {
            queryWrapper.eq(CouponDO::getCouponStatus, couponInfoQO.getState());
        }
        queryWrapper.eq(CouponDO::getIsDel, false);
        queryWrapper.eq(CouponDO::getGetType, CouponConstants.COUPON_USR_TYPE_ACTIVITY);
        queryWrapper.eq(CouponDO::getUseType, couponInfoQO.getUseType());
        queryWrapper.isNull(CouponDO::getParentId);
        queryWrapper.orderByDesc(CouponDO::getCreateTime);
        Page<CouponDO> pages = new Page<>(couponInfoQO.getPageNo(), couponInfoQO.getPageSize());
        Page<CouponDO> pageInfo = this.page(pages, queryWrapper);

        List<CouponActivityDTO> collect = pageInfo.getRecords().stream().map(CouponDO::bilIdCouponActivityDTO)
                .collect(Collectors.toList());
        for (CouponActivityDTO couponActivityDTO : collect) {
            LambdaQueryWrapper<CouponDO> activityWrapper = new LambdaQueryWrapper<>();
            activityWrapper.eq(CouponDO::getParentId, couponActivityDTO.getId());
            CouponActivityDTO activityDTO = this.getOne(activityWrapper).bilIdCouponActivityDTO();
            activityDTO.setActivityRole("beShare");
            couponActivityDTO.setBeSharedCoupon(activityDTO);
        }

        PageResult pageResult = PageResult.buildPage(couponInfoQO.getPageNo(), couponInfoQO.getPageSize(),
                (int) pageInfo.getTotal(), collect);
        return ResultBody.success(pageResult);
    }

    @Override
    public ResultBody getActivityCouponPullDown(Integer type) {
        LambdaQueryWrapper<CouponDO> queryWrapper = new LambdaQueryWrapper<>();
        if (type == 2) {
            queryWrapper.eq(CouponDO::getGetType, CouponConstants.COUPON_ISSUE_TYPE_INITIATIVE);
        } else {
            queryWrapper.eq(CouponDO::getGetType, CouponConstants.COUPON_USR_TYPE_ACTIVITY);
            queryWrapper.isNull(CouponDO::getParentId);
        }
        queryWrapper.eq(CouponDO::getIsDel, false);
        queryWrapper.orderByDesc(CouponDO::getCreateTime);
        List<CouponDO> list = this.list(queryWrapper);
        List<CouponActivityDTO> collect = list.stream().map(CouponDO::bilIdCouponActivityDTO)
                .collect(Collectors.toList());
        for (CouponActivityDTO couponActivityDTO : collect) {
            LambdaQueryWrapper<CouponDO> activityWrapper = new LambdaQueryWrapper<>();
            activityWrapper.eq(CouponDO::getParentId, couponActivityDTO.getId());
            CouponDO one = this.getOne(activityWrapper);
            if (one != null) {
                CouponActivityDTO activityDTO = one.bilIdCouponActivityDTO();
                activityDTO.setActivityRole("beShare");
                couponActivityDTO.setBeSharedCoupon(activityDTO);
            } else {
                couponActivityDTO.setActivityRole(null);
            }
        }
        return ResultBody.success(collect);

    }

    @Override
    public ResultBody increaseCouponCount(Integer id, Integer count) {
        if (count < 0) {
            return ResultBody.error("数量小于0");
        }
        CouponDO coupon = this.getById(id);
        if (coupon == null) {
            return ResultBody.error("数据不存在!");
        }
        //发放总数
        Integer couponTotal = coupon.getCouponTotal();
        Integer newCouponTotal = couponTotal + count;
        //剩余数量
        Integer lastTotal = coupon.getLastTotal();
        Integer newLastTotal = lastTotal + count;

        LambdaUpdateWrapper<CouponDO> update = new LambdaUpdateWrapper();
        update.eq(CouponDO::getId, id)
                .set(CouponDO::getCouponTotal, newCouponTotal)
                .set(CouponDO::getLastTotal, newLastTotal);
        boolean updateStatus = update(update);
        if (updateStatus) {
            return ResultBody.success();
        } else {
            return ResultBody.error("增发失败,请稍后再试");
        }
    }


    @Override
    public ResultBody shutDown(Integer id) {
        CouponDO couponDO = getById(id);
        if (couponDO == null) {
            return ResultBody.error("该优惠券不存在");
        }
        LambdaQueryWrapper<CouponDO> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(CouponDO::getParentId, couponDO.getId());
        List<CouponDO> list = list(queryWrapper);
        if (list.size() > 0) {
            CouponDO coupon = list.get(0);
            LambdaUpdateWrapper<CouponDO> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(CouponDO::getId, coupon.getId()).set(CouponDO::getCouponStatus, false);
            update(updateWrapper);
        }
        LambdaUpdateWrapper<CouponDO> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(CouponDO::getId, id).set(CouponDO::getCouponStatus, false);
        boolean update = update(updateWrapper);
        if (update) {
            return ResultBody.success();
        } else {
            return ResultBody.error("关闭失败,请稍后再试");
        }
    }


    @Override
    public ResultBody couponViewData(Integer id) {
        DecimalFormat df = new DecimalFormat("0.00");

        //总发行量
        CouponDO couponInfo = this.getById(id);
        if (couponInfo == null) {
            return ResultBody.error("该优惠券不存在");
        }
        Integer couponTotal = couponInfo.getCouponTotal();


        //领取量：用户成功领取的券数；
        LambdaQueryWrapper<CouponUserDO> queryWrap = new LambdaQueryWrapper<>();
        queryWrap.eq(CouponUserDO::getCouponId, id);
        queryWrap.ne(CouponUserDO::getStatus, CouponConstants.STORE_COUPON_USER_STATUS_PRESENTED);
        long receiveQuantity = couponUserService.count(queryWrap);


        //领取率：(领取量 / 总发行量) * 100%；
        String claimRate = df.format(((float) receiveQuantity / (float) couponTotal) * 100) + "%";

        //订单中心
        List<Long> collect = couponUserDao.getOrderList(id);
        ResultBody resultBody = null;
        if (collect.size() > 0) {
            resultBody = null;
            //mallOrderClient.feignOrderUseCoupon(collect);
        }

        //用户待付款订单使用的优惠券数量
        Integer obligation = 0;

        //已付款订单使用的优惠券数量 = 有效使用量：用户结算的时候，成功使用优惠券进行抵扣金额的优惠券数量（已付款订单）
        Integer accountPaid = 0;
        if (resultBody != null) {
            Map<String, Integer> result = (Map<String, Integer>) resultBody.getResult();
            obligation = result.get("obligation");
            accountPaid = result.get("accountPaid");
        }

        //使用量：用户待付款订单使用的优惠券数量 + 已付款订单使用的优惠券数量；
        Integer usageAmount = obligation + accountPaid;

        String availability;
        //有效使用率：(有效使用量 / 使用量) * 100%；
        if (usageAmount <= 0) {
            availability = 0 + "%";
        } else {
            availability = df.format(((float) accountPaid / (float) usageAmount) * 100) + "%";
        }


        CouponViewDTO couponViewDTO = new CouponViewDTO();
        couponViewDTO.setCouponTotal(couponTotal);
        couponViewDTO.setReceiveQuantity(receiveQuantity);
        couponViewDTO.setClaimRate(claimRate);
        couponViewDTO.setAccountPaid(accountPaid);
        couponViewDTO.setUsageAmount(usageAmount);
        couponViewDTO.setAvailability(availability);
        return ResultBody.success(couponViewDTO);
    }

    @Override
    public ResultBody getCouponUserList(CouponUserInfoQO couponUserInfoQO) {
        Integer integer = couponUserDao.selectCouponUserInfoCount(couponUserInfoQO);
        couponUserInfoQO.buildCurrentPage();
        List<CouponUserDTO> couponUserDTOS = couponUserDao.selectCouponUserInfoList(couponUserInfoQO);
        PageResult pageResult = PageResult.buildPage(couponUserInfoQO.getPageNo() + 1,
                couponUserInfoQO.getPageSize(), integer, couponUserDTOS);
        return ResultBody.success(pageResult);
    }

    @Override
    public void downloadCouponUserList(HttpServletResponse response, CouponUserInfoQO couponUserInfoQO) throws IOException {
        couponUserInfoQO.setPageNo(0);
        Integer integer = couponUserDao.selectCouponUserInfoCount(couponUserInfoQO);
        couponUserInfoQO.setPageSize(integer);
        List<CouponUserDTO> couponUserDTOS = couponUserDao.selectCouponUserInfoList(couponUserInfoQO);

        List<CouponUserExcel> datas = couponUserDTOS.stream()
                .map(this::buildExUavMallAccount).collect(Collectors.toList());

        Collection<CouponUserExcel> coll = datas;
        Workbook workbook = ExcelExportUtil.exportExcel(
                new ExportParams("优惠券明细数据", "优惠券明细"), CouponUserExcel.class, coll);
        String fileName = "优惠券明细" + TDateUtil.getCurrentDate();
        fileName = URLEncoder.encode(fileName, "UTF8");
        response.setContentType("application/vnd.ms-excel;chartset=utf-8");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + ".xls\"");
        ServletOutputStream out = response.getOutputStream();
        workbook.write(out);
        out.flush();
        out.close();
    }

    @Override
    public List<CouponDTO> feignByIds(List<Integer> ids) {
        List<CouponDO> couponDOS = this.listByIds(ids);
        return couponDOS.stream().map(CouponDO::bilIdCouponDTO).collect(Collectors.toList());
    }

    @Override
    public CouponActivityDTO getCouponActivityById(Integer id) {
        CouponActivityDTO couponActivityDTO = this.getById(id).bilIdCouponActivityDTO();
        LambdaQueryWrapper<CouponDO> activityWrapper = new LambdaQueryWrapper<>();
        activityWrapper.eq(CouponDO::getParentId, couponActivityDTO.getId());
        CouponActivityDTO activityDTO = this.getOne(activityWrapper).bilIdCouponActivityDTO();
        activityDTO.setActivityRole("beShare");
        couponActivityDTO.setBeSharedCoupon(activityDTO);
        return couponActivityDTO;
    }

    @Override
    public List<CouponActivityDTO> getCouponActivityList(List<Integer> id) {
        List<CouponActivityDTO> collect = this.listByIds(id).stream().map(CouponDO::bilIdCouponActivityDTO)
                .collect(Collectors.toList());
        for (CouponActivityDTO couponActivityDTO : collect) {
            if (couponActivityDTO.getParentId() != null) {
                LambdaQueryWrapper<CouponDO> activityWrapper = new LambdaQueryWrapper<>();
                activityWrapper.eq(CouponDO::getParentId, couponActivityDTO.getId());
                CouponActivityDTO activityDTO = this.getOne(activityWrapper).bilIdCouponActivityDTO();
                activityDTO.setActivityRole("beShare");
                couponActivityDTO.setBeSharedCoupon(activityDTO);
            }
        }
        return collect;
    }


    @Override
    public Boolean deduction(Integer id, Integer num, Boolean isLimited) {
        UpdateWrapper<CouponDO> updateWrapper = new UpdateWrapper<>();
        if (isLimited) {
            updateWrapper.setSql(StrUtil.format("last_total = last_total - {}", num));
            updateWrapper.last(StrUtil.format(" and (last_total - {} >= 0)", num));
        } else {
            updateWrapper.setSql(StrUtil.format("last_total = last_total + {}", num));
        }
        updateWrapper.eq("id", id);
        return update(updateWrapper);
    }

    public List<ChannelCouponDO> redeExcel(MultipartFile file) {
        EasyExcelListener<ChannelCouponDO> listener = new EasyExcelListener<ChannelCouponDO>();
        ExcelReader build = null;
        try {
            build = EasyExcel.read(file.getInputStream(), ChannelCouponDO.class, listener).headRowNumber(1).build();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        build.readAll();
        List<ChannelCouponDO> cachedDataList = listener.getCachedDataList();
        build.finish();

        return cachedDataList;

    }

    private CouponUserExcel buildExUavMallAccount(CouponUserDTO m) {
        String type = null;
        if (CouponConstants.STORE_COUPON_USER_TYPE_GET.equals(m.getGainType())) {
            type = "用户领取";
        } else if (CouponConstants.STORE_COUPON_USER_TYPE_SEND.equals(m.getCouponType())) {
            type = "后台发放";
        } else if (CouponConstants.STORE_COUPON_USER_TYPE_PRESENTED.equals(m.getCouponType())) {
            type = "赠送";
        } else if (CouponConstants.STORE_COUPON_USER_TYPE_ACQUIRE.equals(m.getCouponType())) {
            type = "获赠";
        } else if (CouponConstants.STORE_COUPON_USER_TYPE_EXCHANGE.equals(m.getCouponType())) {
            type = "兑换";
        } else if (CouponConstants.STORE_COUPON_USER_TYPE_ACTIVITY.equals(m.getCouponType())) {
            type = "活动领取";
        }
        String status = null;
        if (CouponConstants.STORE_COUPON_USER_STATUS_USABLE.equals(m.getStatus())) {
            status = "未使用";
        } else if (CouponConstants.STORE_COUPON_USER_STATUS_USED.equals(m.getStatus())) {
            status = "已使用";
        } else if (CouponConstants.STORE_COUPON_USER_STATUS_LAPSED.equals(m.getStatus())) {
            status = "已失效";
        } else if (CouponConstants.STORE_COUPON_USER_STATUS_PRESENTED.equals(m.getStatus())) {
            status = "已转赠";
        } else if (CouponConstants.STORE_COUPON_USER_STATUS_IN_USE.equals(m.getStatus())) {
            status = "使用中";
        }
        String entAuthStatus = null;
        if (m.getVerificationType() != null && m.getVerificationType()) {
            entAuthStatus = "多次核销";
        } else {
            entAuthStatus = "单次核销";
        }
        String transform = null;
        if (m.getConversionRatio() != null) {
            transform = "1:" + m.getConversionRatio();
        }
        return CouponUserExcel.builder()
                .couponId(m.getCouponId())
                .uid(m.getUid())
                .userPhone(m.getUserPhone())
                .couponName(m.getCouponName())
                .gainType(type)
                .status(status)
                .createTime(m.getCreateTime())
                .useTime(m.getUseTime())
                .orderNo(m.getOrderNo()).build();
    }

    @Override
    public void overdueCouponTask() {
        // 查询所有状态——可用的优惠券
        LambdaQueryWrapper<CouponDO> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(CouponDO::getCouponStatus, true);
        queryWrapper.eq(CouponDO::getIsDel, false);
        queryWrapper.eq(CouponDO::getIsFixedTime, CouponConstants.COUPON_USE_TIME_FIXED);
        List<CouponDO> list = this.list(queryWrapper);
        if (CollUtil.isEmpty(list)) {
            return;
        }
        List<CouponDO> updateList = CollUtil.newArrayList();
        list.forEach(coupon -> {
            if (ObjectUtil.isNotNull(coupon.getUseEndTime())) {
                if (DateUtil.date().after(coupon.getUseEndTime())) {
                    coupon.setCouponStatus(false);
                    updateList.add(coupon);
                }
            }
        });

        if (CollUtil.isEmpty(updateList)) {
            return;
        }
        boolean update = this.updateBatchById(updateList);
        if (!update) {
            log.error("批量更新优惠券状态动作失败");
        }

    }

    @Override
    public List<CouponDTO> feignGetCouponType(Integer type) {
        LambdaQueryWrapper<CouponDO> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(CouponDO::getIsDel, false);
        queryWrapper.eq(CouponDO::getGetType, CouponConstants.COUPON_ISSUE_TYPE_INITIATIVE);
        queryWrapper.eq(CouponDO::getUserTag, type);
        List<CouponDO> list = this.list(queryWrapper);
        List<CouponDTO> collect = list.stream().map(CouponDO::bilIdCouponDTO).collect(Collectors.toList());
        return collect;
    }

    @Override
    public ResultBody ordinaryActivities(ProductCouponQO productCouponQO) {
        Integer goodsInfoId = productCouponQO.getGoodsInfoId();
        ProductInformationDo product = couponBackDao.findProduct(goodsInfoId);
        if (product == null) {
            return ResultBody.error("当前商品没有优惠券");
        }
        List<CouponDO> couponDOS = couponBackDao.ordinaryActivities(product.getBrandId());
        List<CouponDTO> collect = couponDOS.stream().map(CouponDO::bilIdCouponDTO).collect(Collectors.toList());
        PageResult pageResult = PageResult.buildPage(productCouponQO.getPageNo(), productCouponQO.getPageSize(), collect.size(), collect);
        return ResultBody.success(pageResult);
    }

    @Override
    public ResultBody fissionActivity(ProductCouponQO productCouponQO) {
        Integer goodsInfoId = productCouponQO.getGoodsInfoId();
        ProductInformationDo product = couponBackDao.findProduct(goodsInfoId);
        if (product == null) {
            return ResultBody.error("当前商品没有优惠券");
        }
        List<CouponDO> couponDOS = couponBackDao.fissionActivity(product.getBrandId());
        List<CouponDTO> collect = couponDOS.stream().map(CouponDO::bilIdCouponDTO).collect(Collectors.toList());
        PageResult pageResult = PageResult.buildPage(productCouponQO.getPageNo(), productCouponQO.getPageSize(), collect.size(), collect);
        return ResultBody.success(pageResult);
    }
}
