package com.mmc.oms.entity.lease;

import com.mmc.oms.entity.mall.UserAddressDO;
import com.mmc.oms.model.dto.uav.UavOrderExpressDTO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * (LeaseOrderExpressDO)实体类
 *
 * @author makejava
 * @since 2023-09-22 15:02:22
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class LeaseOrderExpressDO implements Serializable {
    private static final long serialVersionUID = -24578000103219438L;

    private Integer id;

    private Integer leaseOrderId;

    private String sendExpNo;

    private String sendExpCode;
    /**
     * 收货人姓名
     */
    private String takeName;
    /**
     * 收货人电话
     */
    private String takePhone;
    /**
     * 收货地区
     */
    private String takeRegion;
    /**
     * 收货详细地址
     */
    private String takeAddress;
    /**
     * 发货时间
     */
    private Date sendTime;
    /**
     * 是否已签收
     */
    private Integer receive;
    /**
     * 收货人签收时间
     */
    private Date receiveTime;

    private Date updateTime;

    private Date createTime;

    public LeaseOrderExpressDO(UserAddressDO userAddressDO) {
        this.takeName = userAddressDO.getTakeName();
        this.takePhone = userAddressDO.getTakePhone();
        this.takeRegion = userAddressDO.getTakeRegion();
        this.takeAddress = userAddressDO.getTakeAddress();
    }

    public UavOrderExpressDTO buildUavOrderExpressDTO() {
        return UavOrderExpressDTO.builder().id(this.id).uavOrderId(this.leaseOrderId).sendExpNo(this.sendExpNo).sendExpCode(this.sendExpCode).takeName(this.takeName)
                .takePhone(this.takePhone).takeAddress(this.takeAddress).takeRegion(this.takeRegion).receive(this.receive).receiveTime(this.receiveTime)
                .sendTime(this.sendTime).build();
    }
}

