package com.mmc.oms.entity.mall;

import com.mmc.oms.model.dto.mall.OrderGoodsProdDTO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: zj
 * @Date: 2023/6/2 20:29
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
public class OrderGoodsProdDO implements Serializable {
    private static final long serialVersionUID = 698431955075119489L;
    private Integer id;
    private Integer orderId;
    private Integer mallProdShopCarId;
    private Integer goodsInfoId;
    private Integer directoryId;
    private BigDecimal goodsAmount;
    private BigDecimal prodActualPrice;
    private String goodsNo;
    private String goodsName;
    private String mainImg;
    private Integer buyNum;
    private Date createTime;
    private Date updateTime;

    private List<OrderGoodsProdDetailDO> orderGoodsProdDetailDOList;

    public OrderGoodsProdDTO buildOrderGoodsProdDTO(){
        return OrderGoodsProdDTO.builder().id(this.id).orderId(this.orderId).mallProdShopCarId(this.mallProdShopCarId).goodsInfoId(this.goodsInfoId).directoryId(this.directoryId).goodsAmount(this.goodsAmount).goodsNo(this.goodsNo)
                .goodsName(this.goodsName).mainImg(this.mainImg).createTime(this.createTime).updateTime(this.updateTime).buyNum(this.buyNum)
                .orderGoodsProdDetailDTOS(this.orderGoodsProdDetailDOList.stream().map(OrderGoodsProdDetailDO::buildOrderGoodsProdDetailDTO).collect(Collectors.toList()))
                .build();
    }

    public OrderGoodsProdDO(OrderGoodsProdDTO orderGoodsProdDTO){
        this.id = orderGoodsProdDTO.getId();
        this.orderId = orderGoodsProdDTO.getOrderId();
        this.goodsInfoId = orderGoodsProdDTO.getGoodsInfoId();
        this.directoryId = orderGoodsProdDTO.getDirectoryId();
        this.goodsAmount = orderGoodsProdDTO.getGoodsAmount();
        this.goodsNo = orderGoodsProdDTO.getGoodsNo();
        this.goodsName = orderGoodsProdDTO.getGoodsName();
        this.mainImg = orderGoodsProdDTO.getMainImg();
        this.buyNum = orderGoodsProdDTO.getBuyNum();
    }

}