package com.mmc.oms.model.vo.uav;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/9/16 14:49
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class UavCartVO implements Serializable {
    private static final long serialVersionUID = 3679112602652045328L;
    @ApiModelProperty(value = "id")
    private Integer id;
    @ApiModelProperty(value = "用户ID")
    @NotNull(message = "用户ID不能为空")
    private Integer userAccountId;
    @ApiModelProperty(value = "商家id")
    @NotNull(message = "商家id不能为空")
    private Integer thirdBackUserAccountId;
    @ApiModelProperty(value = "商家名称")
    @NotNull(message = "商家名称不能为空")
    private String companyName;
    @ApiModelProperty(value = "商品id")
    @NotNull(message = "商品id不能为空")
    private Integer mallGoodsId;
    @ApiModelProperty(value = "商品名称")
    private String tradeName;
    @ApiModelProperty(value = "商品规格id")
    private Integer priceStockId;
    @ApiModelProperty(value = "商品规格名称")
    @NotNull(message = "商品规格名称不能为空")
    private String productSpec;
    @ApiModelProperty(value = "数量")
    @NotNull(message = "数量不能为空")
    private Integer orderNum;
    @ApiModelProperty(value = "售卖价")
    private BigDecimal salePrice;
    @ApiModelProperty(value = "主图或规格图")
    @NotNull(message = "主图或规格图不能为空")
    private String skuImage;
    @ApiModelProperty(value = "规格编号")
    private String skuNo;
}
