package com.mmc.oms.entity.uav;

import com.mmc.oms.model.dto.uav.UavCartDTO;
import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/9/16 14:03
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("最新版-商城购物车")
public class UavCartDO implements Serializable {
    private static final long serialVersionUID = 3845763818022578395L;
    private Integer id;
    private Integer userAccountId;
    private Integer thirdBackUserAccountId;
    private Integer mallGoodsId;
    private String tradeName;
    private Integer priceStockId;
    private String productSpec;
    private Integer orderNum;
    private BigDecimal salePrice;
    private String skuImage;
    private String skuNo;
    private Date createTime;

    public UavCartDTO buildUavCartDTO() {
        return UavCartDTO.builder().id(this.id).userAccountId(this.userAccountId).thirdBackUserAccountId(thirdBackUserAccountId)
                .mallGoodsId(this.mallGoodsId).tradeName(this.tradeName).priceStockId(this.priceStockId).productSpec(this.productSpec)
                .orderNum(this.orderNum).salePrice(this.salePrice).skuImage(this.skuImage).skuNo(this.skuNo).createTime(createTime)
                .build();
    }

}
