package com.mmc.oms.service;

import com.mmc.oms.common.PageResult;
import com.mmc.oms.common.ResultBody;
import com.mmc.oms.model.dto.BaseAccountDTO;
import com.mmc.oms.model.dto.OrderInfoDTO;
import com.mmc.oms.model.qo.OrderInfoQO;
import com.mmc.oms.model.vo.LeaseOrderVO;
import com.mmc.oms.model.vo.OrderStatusVO;
import com.mmc.oms.model.vo.OrderVcuVO;
import com.mmc.oms.model.vo.ReturnWareVO;

/**
 * @Author small @Date 2023/5/26 10:52 @Version 1.0
 */
public interface RentalOrdersService {


    OrderInfoDTO getOrderDetail(String orderNo);

    OrderInfoDTO feignAddLease(BaseAccountDTO user, LeaseOrderVO param);

    PageResult listPcOrderInfo(OrderInfoQO param, BaseAccountDTO cuser);

    PageResult listPageWechatOrder(BaseAccountDTO account, OrderInfoQO param);

    Object orderStatusChanges(String orderNo, Integer tranStatus);

    ResultBody sendOrderWare(BaseAccountDTO currentAccount, OrderVcuVO param);

    PageResult listOfRentalOrders(OrderStatusVO orderStatusVO, BaseAccountDTO currentAccount);

    ResultBody renterTakeOrder(OrderVcuVO param);

    ResultBody returnOrderWare(ReturnWareVO param);

    ResultBody pfConfirmOrderWare(BaseAccountDTO currentAccount, OrderVcuVO param);
}
