package com.mmc.oms.service;

import com.mmc.oms.common.PageResult;
import com.mmc.oms.common.ResultBody;
import com.mmc.oms.model.dto.*;
import com.mmc.oms.model.qo.OrderInfoQO;
import com.mmc.oms.model.vo.LeaseOrderVO;
import com.mmc.oms.model.vo.OrderReceiptVO;
import com.mmc.oms.model.vo.OrderVcuVO;
import com.mmc.oms.model.vo.ReturnWareVO;

import java.util.List;

/**
 * @Author small
 * @Date 2023/5/31 16:14
 * @Version 1.0
 */
public interface OrderLogisticsService {
    OrderInfoDTO feignAddLease(LeaseOrderVO param);

    List<TranStatusDicDTO> listTranStatus();

    OrderInfoDTO getOrderDetail(String orderNo);

    ResultBody closeSelfOrder(Integer orderInfoId, String shutReason);

    ResultBody platFormCloseOrder(Integer orderInfoId, String shutReason);

    ResultBody updateOrderAddr(OrderReceiptVO param);

    ResultBody updateOrderShop(OrderReceiptVO param);

    OrderInfoDTO getOrderSimpleInfo(Integer orderInfoId);

    ResultBody payCashOrder(BaseAccountDTO account, Integer orderInfoId);

    PageResult listPageWechatOrder(BaseAccountDTO account, OrderInfoQO param);

    List<KdnDicDTO> listKdnDic();

    List<ExpressInfoDTO> listExpressInfo();

    PageResult listPcOrderInfo(OrderInfoQO param,BaseAccountDTO cuser);

    CountOrderDTO countOrderInfo(BaseAccountDTO cuser);

    ResultBody sendOrderWare(BaseAccountDTO cuser, OrderVcuVO param);

    ResultBody renterTakeOrder(OrderVcuVO param);

    ResultBody batchTakeOrder();

    ResultBody pfConfirmOrderWare(BaseAccountDTO cuser, OrderVcuVO param);

    ResultBody returnOrderWare(ReturnWareVO param);

    OrderReceiptDTO getOrderReceiptInfo(Integer orderInfoId);

    ResultBody orderExpressInfo(Integer orderInfoId);

    ResultBody refundExpressInfo(Integer orderInfoId);

    OrderInfoDTO pfOrderDetail(Integer orderInfoId);

    ResultBody updateReceipt(OrderReceiptVO param);

    ResultBody batchCloseWaitPayOrder();

    int listPcOrderInfoCount();

    Integer getOrderInfoCount(Integer dayNum,Integer dateType);

    ResultBody testSendMsg(Integer id);

    void SynchronousDataToPushMoney(String OrderNo);
}

