package com.mmc.oms.service.Impl;

import com.alibaba.fastjson.JSONObject;
import com.mmc.oms.common.*;
import com.mmc.oms.dao.OrderLogisticsDao;
import com.mmc.oms.dao.OrderRefundDao;
import com.mmc.oms.entity.OrderInfoDO;
import com.mmc.oms.entity.OrderReceiptDO;
import com.mmc.oms.entity.OrderRefundDO;
import com.mmc.oms.entity.OrderVcuDO;
import com.mmc.oms.model.dto.*;
import com.mmc.oms.model.qo.OrderInfoQO;
import com.mmc.oms.model.vo.*;
import com.mmc.oms.service.OrderLogisticsService;
import com.mmc.oms.wx.WxMsgTemplete;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * @Author small
 * @Date 2023/5/31 16:21
 * @Version 1.0
 */
@Service
@Slf4j
public class OrderLogisticsServiceImpl implements OrderLogisticsService {

    private final static String SYSTEM_CLOSE_PAYORDER_REASON = "逾期未支付，系统自动关闭订单";

    @Autowired
    private OrderLogisticsDao orderLogisticsDao;

    @Autowired
    private OrderRefundDao orderRefundDao;

  /*  @Autowired
    private RepoPayServletClient repoPayServletClient;

    @Autowired
    private WareServletClient wareServletClient;

    @Autowired
    private RepoDeviceServletClient repoDeviceServletClient;

    @Autowired
    private UserServletClient userServletClient;

    @Autowired
    private RepoServletClient repoServletClient;*/

    @Autowired
    private StringRedisTemplate stringRedisTemplate;

   @Autowired
   private Publicsher publicsher;

    @Autowired
    private ThreadPoolExecutor executor;

    /*@Resource
    private OrderServletClient orderServletClient;*/

    @Override
    public OrderInfoDTO feignAddLease(LeaseOrderVO param) {
        OrderInfoDO orderInfo = new OrderInfoDO(param);
        orderLogisticsDao.insertOrderInfo(orderInfo);
        // 添加收货地址
        Date cdate = new Date();
        OrderReceiptVO rv = param.getOrderReceipt();
        OrderReceiptDO receipt = new OrderReceiptDO(rv);
        receipt.setOrderInfoId(orderInfo.getId());
        receipt.setCreateTime(cdate);
        orderLogisticsDao.insertOrderReceipt(receipt);

        OrderInfoDTO dto = orderInfo.buildOrderInfoDTO();
        // 发布订阅通知
        publicsher.sendRepoOrderInit(dto);
        return dto;
    }

    private void sendToBePaidMsg(Integer id) {
        OrderInfoDO orderInfo = orderLogisticsDao.getOrderInfo(id);
        /*RepoAccountDTO wechat = repoServletClient.feignRepoLoginInfo(orderInfo.getRepoAccountId());
        if (wechat == null || StringUtils.isBlank(wechat.getOpenId())) {
            return;
        }*/
        AppletMsgVO aMsg = new AppletMsgVO();
        //aMsg.setTouser(wechat.getOpenId());
        aMsg.setTemplate_id(WxMsgTemplete.AT_REPO_TO_BE_PAID);
        aMsg.setPage(WxMsgDataConfig.REPO_SHIP_MESSAGE);

        // 租赁产品
        JSONObject thing2 = new JSONObject();
        thing2.put("value", orderInfo.getWareTitle());

        // 订单编号
        JSONObject characterString1 = new JSONObject();
        characterString1.put("value", orderInfo.getOrderNo());

        // 租赁时间
        JSONObject time3 = new JSONObject();
        time3.put("value", TDateUtil.getDateStr(orderInfo.getCreateTime(), "yyyy-MM-dd HH:mm:ss"));

        // 订单金额
        JSONObject amount6 = new JSONObject();
        amount6.put("value", orderInfo.getShouldPay().toString());

        // 订单金额
        JSONObject thing9 = new JSONObject();
        thing9.put("value", "请尽快完成订单支付");

        JSONObject data = new JSONObject();
        data.put("character_string1", characterString1);
        data.put("thing2", thing2);
        data.put("time3", time3);
        data.put("amount6", amount6);
        data.put("thing9", thing9);
        aMsg.setData(data);
       // repoServletClient.asynSendUserAppletMsg(aMsg);
    }

    @Override
    public List<TranStatusDicDTO> listTranStatus() {
        return orderLogisticsDao.listTranStatus().stream().map(d -> {
            return d.buildTranStatusDicDTO();
        }).collect(Collectors.toList());
    }

    @Override
    public OrderInfoDTO getOrderDetail(String orderNo) {
        OrderInfoDO order = orderLogisticsDao.getOrderDetail(orderNo);
        OrderInfoDTO orderInfo = order.buildOrderInfoDTO();
        OrderReceiptDO rd = orderLogisticsDao.getOrderReceiptInfo(order.getId());
        OrderReceiptDTO receipt = rd.buildOrderReceiptDTO();
        orderInfo.setReceipt(receipt);
        // 查询-最新的退款详情单
        OrderRefundDO orderRefund = orderRefundDao.getNewOrderRefund(order.getId());
        if (orderRefund != null) {
            OrderRefundDTO refund = orderRefund.buildOrderRefundDTO();
            orderInfo.setOrderRefund(refund);
        }
        return orderInfo;
    }

    @Override
    @Transactional
    public ResultBody closeSelfOrder(Integer orderInfoId, String shutReason) {
        OrderInfoDO order = orderLogisticsDao.getOrderInfo(orderInfoId);
        if (order == null) {
            return ResultBody.error(ResultEnum.ORDER_POWER_ERROR);
        }
        if (!TranStatusDic.INIT.getStatus().equals(order.getTranStatus())) {
            return ResultBody.error(ResultEnum.ORDER_STATUS_ERROR);
        }
        OrderInfoDO upOrder = new OrderInfoDO();
        upOrder.setId(orderInfoId);
        upOrder.setTranStatus(TranStatusDic.CLOSE.getStatus());
        upOrder.setShutReason(shutReason);
        orderLogisticsDao.updateOrderInfo(upOrder);

        if (WarePayStatus.BEFORE.getStatus().equals(order.getExWare().toString())) {
            OrderInfoVO stock = OrderInfoVO.builder().wareInfoId(order.getWareInfoId()).skuInfoId(order.getSkuInfoId())
                    .addStock(order.getWareNum()).build();
            ResultBody stockResult = null;
                    //wareServletClient.feignOrderNum(stock);
            return stockResult;
        }
        return ResultBody.success();
    }

    @Override
    @Transactional
    public ResultBody platFormCloseOrder(Integer orderInfoId, String shutReason) {
        OrderInfoDO order = orderLogisticsDao.getOrderInfo(orderInfoId);
        OrderInfoDO upOrder = new OrderInfoDO();
        upOrder.setId(orderInfoId);
        upOrder.setTranStatus(TranStatusDic.CLOSE.getStatus());
        upOrder.setShutReason(shutReason);
        orderLogisticsDao.updateOrderInfo(upOrder);

        if (WarePayStatus.BEFORE.getStatus().equals(order.getExWare().toString())) {
            OrderInfoVO stock = OrderInfoVO.builder().wareInfoId(order.getWareInfoId()).skuInfoId(order.getSkuInfoId())
                    .addStock(order.getWareNum()).build();
            ResultBody stockResult =null;
                    //wareServletClient.feignOrderNum(stock);
            return stockResult;
        }
        return ResultBody.success();
    }

    @Override
    public ResultBody batchCloseWaitPayOrder() {
        List<String> errorOrders = new ArrayList<String>();
        List<OrderInfoDO> orderList = orderLogisticsDao.listOrderByTranStatus(TranStatusDic.INIT.getStatus());
        if (!CollectionUtils.isEmpty(orderList)) {
            Date cdate = new Date();
            for (OrderInfoDO d : orderList) {
                //设置下单时间66小时之后
                Date notificationTime = TDateUtil.addHourTime(d.getCreateTime(), 66);
                Date ndate = TDateUtil.nextNumDateTime(d.getCreateTime(), 3);
                if (cdate.compareTo(notificationTime) >= 0 && cdate.compareTo(ndate) <= 0) {
                    String key = RedisConstant.createRepoOrderOver(d.getId());
                    boolean isSended = stringRedisTemplate.hasKey(key);
                    if (!isSended) {
                        this.sendToBePaidMsg(d.getId());
                        stringRedisTemplate.opsForValue().set(key, key, 1L, TimeUnit.DAYS);
                    }
                }

                if (ndate.compareTo(cdate) <= 0) {// 已到时间，自动更新
                    try {
                        this.platFormCloseOrder(d.getId(), SYSTEM_CLOSE_PAYORDER_REASON);
                    } catch (Exception e) {
                        // 记录定时任务有误的订单
                        errorOrders.add(d.getOrderNo());
                    }
                }

            }
        }
        if (!CollectionUtils.isEmpty(errorOrders)) {
            return ResultBody.error(ResultEnum.ORDER_PAY_JOB_ERROR, errorOrders);
        }
        return ResultBody.success();
    }

    @Override
    public ResultBody updateOrderAddr(OrderReceiptVO param) {
        OrderReceiptDO receipt = new OrderReceiptDO(param);
        orderLogisticsDao.updateOrderReceipt(receipt);
        return ResultBody.success();
    }

    @Override
    public ResultBody updateOrderShop(OrderReceiptVO param) {
        OrderReceiptDO receipt = new OrderReceiptDO(param);
        orderLogisticsDao.updateOrderReceipt(receipt);
        return ResultBody.success();
    }

    @Override
    public OrderInfoDTO getOrderSimpleInfo(Integer orderInfoId) {
        OrderInfoDO order = orderLogisticsDao.getOrderSimpleInfo(orderInfoId);
        return order == null ? null : order.buildOrderInfoDTO();
    }

    @Override
    @Transactional
    public ResultBody payCashOrder(BaseAccountDTO account, Integer orderInfoId) {
        OrderInfoDTO orderInfo = this.getOrderSimpleInfo(orderInfoId);
        if (!orderInfo.getTranStatus().equals(TranStatusDic.INIT.getStatus())) {
            return ResultBody.error(ResultEnum.ORDER_STATUS_ERROR);
        }

        // 更新商品库存信息&销量信息
        Integer addStock;
        Integer addSale;
        if (orderInfo.getExWare().toString().equals(WarePayStatus.BEFORE.getStatus())) {
            addStock = null;
            addSale = orderInfo.getWareNum();
        } else {
            addStock = (orderInfo.getWareNum() * -1);
            addSale = orderInfo.getWareNum();
        }
        OrderInfoVO stock = OrderInfoVO.builder().exWare(orderInfo.getExWare()).wareInfoId(orderInfo.getWareInfoId())
                .skuInfoId(orderInfo.getSkuInfoId()).addStock(addStock).addSale(addSale).build();
        ResultBody stockResult =null;
                //wareServletClient.feignOrderNum(stock);
        if (!ResultEnum.SUCCESS.getResultCode().equals(stockResult.getCode())) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return stockResult;
        }

        // 结账流水
        RepoOrderPayVO orderPay = RepoOrderPayVO.builder().orderInfo(orderInfo).account(account).build();
        PayCashResultDTO result = null;
                //repoPayServletClient.feignPayCashOrder(orderPay);
        if (!ResultEnum.SUCCESS.getResultCode().equals(result.getStatus())) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return ResultBody.error(result.getStatus(), result.getMessage());
        }
        Date cdate = new Date();
        // 修改订单状态
        OrderInfoDO upOrder = new OrderInfoDO();
        upOrder.setId(orderInfoId);
        upOrder.setTranStatus(TranStatusDic.YFK.getStatus());
        upOrder.setActualPay(result.getCashPaid());
        upOrder.setPayNo(result.getPayNo());
        upOrder.setPayTime(cdate);
        orderLogisticsDao.updateOrderInfo(upOrder);
        return ResultBody.success();
    }

    @Override
    public PageResult listPageWechatOrder(BaseAccountDTO account, OrderInfoQO param) {
        param.setRepoAccountId(account.getUserAccountId());
        int count = orderLogisticsDao.countPageOrderInfo(param);
        if (count == 0) {
            return PageResult.buildPage(param.getPageNo(), param.getPageSize(), count);
        }
        Integer pageNo = param.getPageNo();
        param.buildCurrentPage();
        List<OrderInfoDTO> data = orderLogisticsDao.listPageOrderInfo(param).stream().map(d -> {
            return d.buildOrderInfoDTO();
        }).collect(Collectors.toList());
        return PageResult.buildPage(pageNo, param.getPageSize(), count, data);
    }

    @Override
    public List<KdnDicDTO> listKdnDic() {
        return orderLogisticsDao.listKdnDic().stream().map(d -> {
            return d.buildKdnDicDTO();
        }).collect(Collectors.toList());
    }

    @Override
    public PageResult listPcOrderInfo(OrderInfoQO param, BaseAccountDTO cuser) {
        /*if (!cuser.isManage()) {
            param.setCompanys(cuser.getCompanyInfo().getCompanys());
        }*/
        Integer count = orderLogisticsDao.countPcOrderInfo(param);
        if (count == 0) {
            return PageResult.buildPage(param.getPageNo(), param.getPageSize(), count);
        }
        Integer pageNo = param.getPageNo();
        param.buildCurrentPage();
        List<OrderInfoDTO> data = orderLogisticsDao.listPcOrderInfo(param).stream().map(d -> {
            return d.buildOrderInfoDTO();
        }).collect(Collectors.toList());
        return PageResult.buildPage(pageNo, param.getPageSize(), count, data);
    }

    @Override
    public CountOrderDTO countOrderInfo(BaseAccountDTO account) {
        List<Integer> companys = null;
        /*if(!account.isManage()){
            companys = account.getCompanyInfo().getCompanys();
        }*/
        Integer waitPay = orderLogisticsDao.countOrderInfo(TranStatusDic.INIT.getStatus(), companys);
        Integer waitEx = orderLogisticsDao.countOrderInfo(TranStatusDic.YFK.getStatus(), companys);
        Integer waitRetreat = orderLogisticsDao.countOrderInfo(TranStatusDic.TKSQ.getStatus(), companys);
        Integer waitReturn = orderLogisticsDao.countOrderInfo(TranStatusDic.GHZ.getStatus(), companys);
        return CountOrderDTO.builder().waitPay(waitPay).waitEx(waitEx).waitRetreat(waitRetreat).waitReturn(waitReturn)
                .build();
    }

    @Override
    public List<ExpressInfoDTO> listExpressInfo() {
        return orderLogisticsDao.listExpressInfo().stream().map(d -> {
            return d.buildExpressInfoDTO();
        }).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public ResultBody sendOrderWare(BaseAccountDTO cuser, OrderVcuVO param) {
        // 密码认证
        ResultBody body = null;
                //userServletClient.feignAuthUserPwd(cuser.getId(), param.getAuthPwd());
        if (!ResultEnum.SUCCESS.getResultCode().equals(body.getCode())) {
            return body;
        }

        OrderInfoDO order = orderLogisticsDao.getOrderInfo(param.getOrderInfoId());
        if (!TranStatusDic.YFK.getStatus().equals(order.getTranStatus())
                && !TranStatusDic.TKSQ.getStatus().equals(order.getTranStatus())) {
            return ResultBody.error(ResultEnum.ORDER_STATUS_ERROR);
        }
        Date cdate = new Date();
        // 修改收发货地址信息
        OrderReceiptDO receipt = param.buildReceipt();
        orderLogisticsDao.updateOrderReceipt(receipt);

        // 订单-视频、图片
        OrderVcuDO vcu = param.buildOrdeVcu();
        vcu.setVcuType(VcuType.SEND.getCode());
        vcu.setCreateTime(cdate);
        orderLogisticsDao.insertOrderVcu(vcu);

        // 修改订单状态
        OrderInfoDO upOrder = new OrderInfoDO();
        upOrder.setId(param.getOrderInfoId());
        upOrder.setTranStatus(TranStatusDic.YFH.getStatus());
        upOrder.setSendWareTime(cdate);
        orderLogisticsDao.updateOrderInfo(upOrder);
        this.sendShipMsg(param.getOrderInfoId());
        return ResultBody.success();
    }

    private void sendShipMsg(Integer orderInfoId) {
        OrderInfoDO orderInfo = orderLogisticsDao.getOrderInfo(orderInfoId);
        RepoAccountDTO wechat =null;
                //repoServletClient.feignRepoLoginInfo(orderInfo.getRepoAccountId());
        OrderReceiptDO receipt = orderLogisticsDao.getOrderReceiptByOrder(orderInfoId);
        if (wechat == null || StringUtils.isBlank(wechat.getOpenId())) {
            return;
        }
        AppletMsgVO aMsg = new AppletMsgVO();
        aMsg.setTouser(wechat.getOpenId());
        aMsg.setTemplate_id(WxMsgTemplete.AT_REPO_SHIP);
        aMsg.setPage(WxMsgDataConfig.REPO_SHIP_MESSAGE);
        // 订单号
        JSONObject orderNo = new JSONObject();
        orderNo.put("value", orderInfo.getOrderNo());

        // 商品名称
        JSONObject wareName = new JSONObject();
        wareName.put("value", orderInfo.getWareTitle());

        // 快递公司
        JSONObject expressName = new JSONObject();
        expressName.put("value", receipt.getExName());

        // 快递单号
        JSONObject expressNo = new JSONObject();
        expressNo.put("value", receipt.getSendExNo());

        // 收货人
        JSONObject receiptName = new JSONObject();
        receiptName.put("value", receipt.getTakeName());
        JSONObject data = new JSONObject();
        data.put("character_string10", orderNo);
        data.put("thing1", wareName);
        data.put("phrase3", expressName);
        data.put("character_string4", expressNo);
        data.put("thing11", receiptName);
        aMsg.setData(data);
        //repoServletClient.asynSendUserAppletMsg(aMsg);
    }

    @Override
    public OrderReceiptDTO getOrderReceiptInfo(Integer orderInfoId) {
        OrderReceiptDO receipt = orderLogisticsDao.getOrderReceiptInfo(orderInfoId);
        return receipt == null ? null : receipt.buildOrderReceiptDTO();
    }

    @Override
    public ResultBody renterTakeOrder(OrderVcuVO param) {
        OrderInfoDO order = orderLogisticsDao.getOrderInfo(param.getOrderInfoId());
        if (!TranStatusDic.YFH.getStatus().equals(order.getTranStatus())) {
            return ResultBody.error(ResultEnum.ORDER_STATUS_ERROR);
        }
        // 订单-视频、图片
        OrderVcuDO vcu = param.buildOrdeVcu();
        vcu.setVcuType(VcuType.REC.getCode());
        vcu.setCreateTime(new Date());
        orderLogisticsDao.insertOrderVcu(vcu);

        // 修改订单状态
        OrderInfoDO upOrder = new OrderInfoDO();
        upOrder.setId(param.getOrderInfoId());
        upOrder.setTranStatus(TranStatusDic.ZLZ.getStatus());
        orderLogisticsDao.updateOrderInfo(upOrder);
        return ResultBody.success();
    }

    @Override
    public ResultBody updateReceipt(OrderReceiptVO param) {
        OrderReceiptDO receipt = param.buildOrderReceiptDO();
        orderLogisticsDao.updateOrderReceipt(receipt);
        return ResultBody.success();
    }

    @Override
    public ResultBody returnOrderWare(ReturnWareVO param) {
        OrderInfoDO order = orderLogisticsDao.getOrderInfo(param.getOrderInfoId());
        if (!TranStatusDic.ZLZ.getStatus().equals(order.getTranStatus())) {
            return ResultBody.error(ResultEnum.ORDER_STATUS_ERROR);
        }

        if (param.getRenMethod() == RenMethod.EXPRESS.getCode()) {
            if (StringUtils.isBlank(param.getRenExCode()) || StringUtils.isBlank(param.getRenExNo())) {
                return ResultBody.error(ResultEnum.EXPRESS_RETURN_ERROR);
            }
            OrderReceiptDO receipt = new OrderReceiptDO();
            receipt.setOrderInfoId(param.getOrderInfoId());
            receipt.setRenMethod(RenMethod.EXPRESS.getCode());
            receipt.setRenExCode(param.getRenExCode());
            receipt.setRenExNo(param.getRenExNo());
            orderLogisticsDao.updateOrderReceipt(receipt);
        } else {
            if (param.getRepoInfoId() == null) {
                return ResultBody.error(ResultEnum.SHOP_RETURN_ERROR);
            }
            RepoInfoDTO repoInfo = null;
                    //repoDeviceServletClient.feignGetRepoShop(param.getRepoInfoId());
            if (repoInfo == null) {
                return ResultBody.error(ResultEnum.FEIGN_DEVICE_SERVLET_ERROR);
            }
            OrderReceiptDO receipt = new OrderReceiptDO();
            receipt.setOrderInfoId(param.getOrderInfoId());
            receipt.setRenMethod(RenMethod.SHOP.getCode());
            receipt.setRenRepoName(repoInfo.getRepoName());
            receipt.setRenRepoAddr(repoInfo.getRepoAddress());
            UserAccountDTO repoUser = null;
                    //userServletClient.feignGetUserSimpleInfo(repoInfo.getUserAccountId());
            if (repoUser == null) {
                return ResultBody.error(ResultEnum.FEIGN_USER_SERVLET_ERROR);
            }
            receipt.setRenRepoPhone(repoUser.getPhoneNum());
            orderLogisticsDao.updateOrderReceipt(receipt);
        }

        // 订单-视频、图片
        OrderVcuDO vcu = param.buildOrdeVcu();
        vcu.setVcuType(VcuType.RETURN.getCode());
        vcu.setCreateTime(new Date());
        orderLogisticsDao.insertOrderVcu(vcu);

        // 修改订单状态
        OrderInfoDO upOrder = new OrderInfoDO();
        upOrder.setId(param.getOrderInfoId());
        upOrder.setTranStatus(TranStatusDic.GHZ.getStatus());
        orderLogisticsDao.updateOrderInfo(upOrder);
        return ResultBody.success();
    }

    @Override
    public ResultBody pfConfirmOrderWare(BaseAccountDTO cuser, OrderVcuVO param) {
        // 密码认证
        ResultBody body =null;
                //userServletClient.feignAuthUserPwd(cuser.getId(), param.getAuthPwd());
        if (!ResultEnum.SUCCESS.getResultCode().equals(body.getCode())) {
            return body;
        }
        OrderInfoDO order = orderLogisticsDao.getOrderInfo(param.getOrderInfoId());
        if (!TranStatusDic.GHZ.getStatus().equals(order.getTranStatus())) {
            return ResultBody.error(ResultEnum.ORDER_STATUS_ERROR);
        }
        // 订单-视频、图片
        OrderVcuDO vcu = param.buildOrdeVcu();
        vcu.setVcuType(VcuType.PFREC.getCode());
        vcu.setCreateTime(new Date());
        orderLogisticsDao.insertOrderVcu(vcu);
        // 修改订单状态
        OrderInfoDO upOrder = new OrderInfoDO();
        upOrder.setId(param.getOrderInfoId());
        upOrder.setTranStatus(TranStatusDic.JYWC.getStatus());
        orderLogisticsDao.updateOrderInfo(upOrder);
        // 以异步方式同步数据到分成明细表 云仓
        this.SynchronousDataToPushMoney(order.getOrderNo());
        return ResultBody.success();
    }

    @Override
    public void SynchronousDataToPushMoney(String OrderNo) {
        CompletableFuture.runAsync(()->{
            OrderInfoDO upOrder = orderLogisticsDao.getOrderDetail(OrderNo);
            Integer rcdCompanyId = upOrder.getRcdCompanyId();
            Integer repoAccountId = upOrder.getRepoAccountId();
            Date createTime = upOrder.getCreateTime();
            if(rcdCompanyId == null){
                log.info("推荐机构ID为空,不参与过分成管理");
            }
            // 通过用户ID查找对应分享码单位
            ResultBody<CompanyInfoDTO> result = null;
                    //userServletClient.queryCompanyInfoById(rcdCompanyId);
            if(Objects.isNull(result)){
                // 失败重试
                result = null;
                        //userServletClient.queryCompanyInfoById(rcdCompanyId);
            }
            if(Objects.isNull(result)){
                log.info("订单ID为[{}],推荐机构ID为[{}],没有参与过分享码活动",upOrder.getId(),rcdCompanyId);
                return;
            }
            if(Objects.isNull(result.getResult().getId())){
                log.info("订单ID为[{}],用户ID为[{}],没有参与过分享码活动,不记录到分成明细中",upOrder.getId(),repoAccountId);
            }
            CompanyInfoDTO companyInfoDTO = result.getResult();
            // 记录到订单明细中
            String s = stringRedisTemplate.opsForValue().get(RedisConstant.TAGINFOALLOT_QUESTALL);
            if(s==null){
                log.error("访问redis的key值失败,其key为[{}]", RedisConstant.TAGINFOALLOT_QUESTALL);
                return;
            }
            List<TagInfoAllotVO> tagInfoAllotDOS = JSONObject.parseArray(s,TagInfoAllotVO.class);
            Optional<TagInfoAllotVO> tagInfoAllot = tagInfoAllotDOS.stream().filter(item -> item.getTagName().equals(companyInfoDTO.getChannelLevel())).findFirst();
            if(Objects.nonNull(tagInfoAllot)){
                TagInfoAllotVO tagInfoAllotVO = tagInfoAllot.get();
                //orderServletClient.pushMoneyDetailInsert(new PushMoneyDetailVO(upOrder.getOrderNo(),repoAccountId,companyInfoDTO.getId(),tagInfoAllotVO.getProportion(),tagInfoAllotVO.getSupProportion(),PushMoneyEnum.STORE_CHANNEL.getCode(),createTime));
            }
        },executor);
    }

    @Override
    public ResultBody orderExpressInfo(Integer orderInfoId) {
        // 订单信息
        OrderInfoDTO orderInfo = this.getOrderSimpleInfo(orderInfoId);
        // 收发货信息
        OrderReceiptDTO receipt = this.getOrderReceiptInfo(orderInfoId);
        // 物流Api信息
        KdnExpDTO expressInfo = null;
        try {
            expressInfo = this.getOrderExpInfo(receipt);
        } catch (Exception e) {
            return ResultBody.error(ResultEnum.ORDER_EXPRESS_ERROR);
        }
        orderInfo.setExpress(expressInfo);
        return ResultBody.success(orderInfo);
    }

    private KdnExpDTO getOrderExpInfo(OrderReceiptDTO receipt) throws Exception {
        String json = "";
        if ("SF".equals(receipt.getSendExCode())) {
            json = KdnExpressUtil.SF(receipt.getTakePhone(), receipt.getSendExNo());
        } else if ("JD".equals(receipt.getSendExCode())) {
            json = KdnExpressUtil.JD("", receipt.getSendExNo());
        } else {
            json = KdnExpressUtil.others(receipt.getSendExCode(), receipt.getSendExNo());
        }
        KdnExpDTO exp = JsonUtil.parseJsonToObj(json, KdnExpDTO.class);
        exp.setLogisticCode(receipt.getSendExNo());
        if (!CollectionUtils.isEmpty(exp.getTraces())) {
            Collections.sort(exp.getTraces(), Comparator.comparing(ExpStationsDTO::getAcceptTime).reversed());// 升序
        }
        return exp;
    }

    private KdnExpDTO getRefundExpInfo(OrderReceiptDTO receipt) throws Exception {
        String json = "";
        if ("SF".equals(receipt.getRenExCode())) {
            json = KdnExpressUtil.SF(receipt.getRenPhone(), receipt.getRenExNo());
        } else if ("JD".equals(receipt.getRenExCode())) {
            json = KdnExpressUtil.JD("", receipt.getRenExNo());
        } else {
            json = KdnExpressUtil.others(receipt.getRenExCode(), receipt.getRenExNo());
        }
        KdnExpDTO exp = JsonUtil.parseJsonToObj(json, KdnExpDTO.class);
        exp.setLogisticCode(receipt.getRenExNo());
        if (!CollectionUtils.isEmpty(exp.getTraces())) {
            Collections.sort(exp.getTraces(), Comparator.comparing(ExpStationsDTO::getAcceptTime).reversed());// 升序
        }
        return exp;
    }

    @Override
    public OrderInfoDTO pfOrderDetail(Integer orderInfoId) {
        OrderInfoDO order = orderLogisticsDao.getOrderInfo(orderInfoId);
        OrderInfoDTO orderInfo = order.buildOrderInfoDTO();
        // 查询物流信息
        OrderReceiptDTO receipt = this.getOrderReceiptInfo(orderInfoId);
        orderInfo.setReceipt(receipt);

        try {
            // 发货-物流动态
            if (!StringUtils.isEmpty(receipt.getSendExCode()) && !StringUtils.isEmpty(receipt.getSendExNo())) {
                KdnExpDTO exp = this.getOrderExpInfo(receipt);
                orderInfo.setExpress(exp);
            }

            // 收货-物流动态
            if (!StringUtils.isEmpty(receipt.getRenExCode()) && !StringUtils.isEmpty(receipt.getRenExNo())) {
                KdnExpDTO rexp = this.getRefundExpInfo(receipt);
                orderInfo.setRefundExpress(rexp);
            }
        } catch (Exception e) {
            // 不影响
        }

        // 退货-物流详情

        // 质检详情
        List<OrderVcuDO> vcuList = orderLogisticsDao.listOrderVcuInfo(orderInfoId);
        if (!CollectionUtils.isEmpty(vcuList)) {
            vcuList.removeIf(d -> VcuType.RETREAT.getCode().toString().equals(d.getVcuType().toString()));
            orderInfo.setVcus(vcuList.stream().map(d -> {
                return d.buildOrderVcuDTO();
            }).collect(Collectors.toList()));
        }
        return orderInfo;
    }

    @Override
    public ResultBody batchTakeOrder() {
        // 批量-自动确认收货
        orderLogisticsDao.batchUpdateConfirmTake();
        return ResultBody.success();
    }

    @Override
    public ResultBody refundExpressInfo(Integer orderInfoId) {
        // 订单信息
        OrderInfoDTO orderInfo = this.getOrderSimpleInfo(orderInfoId);
        // 收发货信息
        OrderReceiptDTO receipt = this.getOrderReceiptInfo(orderInfoId);
        if (StringUtils.isBlank(receipt.getRenExCode()) || StringUtils.isBlank(receipt.getRenExNo())) {
            return ResultBody.error(ResultEnum.EX_INFO_ERROR);
        }
        // 物流Api信息
        KdnExpDTO expressInfo = null;
        try {
            expressInfo = this.getRefundExpInfo(receipt);
        } catch (Exception e) {
            return ResultBody.error(ResultEnum.ORDER_EXPRESS_ERROR);
        }
        orderInfo.setRefundExpress(expressInfo);
        return ResultBody.success(orderInfo);
    }

    @Override
    public int listPcOrderInfoCount() {
        return orderLogisticsDao.listPcOrderInfoCount();
    }

    @Override
    public Integer getOrderInfoCount(Integer dayNum, Integer dateType) {
        // 判断进来的是那个标识
        if (dateType == 0) {
            if (OrderCountDayNum.yesterday.getDay().equals(dayNum)) {
                return orderLogisticsDao.getOrderInfoCountToYesterday(OrderCountDayNum.yesterday.getDay(), new Date());
            } else if (OrderCountDayNum.recentWeek.getDay().equals(dayNum)) {
                return orderLogisticsDao.getOrderInfoCount(OrderCountDayNum.recentWeek.getDay(), new Date());
            } else if (OrderCountDayNum.recentMonth.getDay().equals(dayNum)) {
                return orderLogisticsDao.getOrderInfoCount(OrderCountDayNum.recentMonth.getDay(), new Date());
            } else if (OrderCountDayNum.two.getDay().equals(dayNum)) {
                return orderLogisticsDao.getOrderInfoCount(OrderCountDayNum.two.getDay(), new Date());
            } else if (OrderCountDayNum.fourteen.getDay().equals(dayNum)) {
                return orderLogisticsDao.getOrderInfoCount(OrderCountDayNum.fourteen.getDay(), new Date());
            } else if (OrderCountDayNum.thirty.getDay().equals(dayNum)) {
                return orderLogisticsDao.getOrderInfoCount(OrderCountDayNum.thirty.getDay(), new Date());
            }
        } else if (dateType == 1) {
            if (OrderCountDayNum.yesterday.getDay().equals(dayNum)) {
                return orderLogisticsDao.getOrderInfoCountToYesterday(OrderCountDayNum.yesterday.getDay(), TDateUtil.getLastYearTodayDate());
            } else if (OrderCountDayNum.recentWeek.getDay().equals(dayNum)) {
                return orderLogisticsDao.getOrderInfoCount(OrderCountDayNum.recentWeek.getDay(), TDateUtil.getLastYearTodayDate());
            } else if (OrderCountDayNum.recentMonth.getDay().equals(dayNum)) {
                return orderLogisticsDao.getOrderInfoCount(OrderCountDayNum.recentMonth.getDay(), TDateUtil.getLastYearTodayDate());
            }
        }
        return null;
    }

    @Override
    public ResultBody testSendMsg(Integer id) {
        this.sendToBePaidMsg(id);
        return ResultBody.success();
    }
}
