package com.mmc.oms.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.mmc.oms.common.ResultBody;
import com.mmc.oms.entity.CouponDO;
import com.mmc.oms.model.dto.CouponActivityDTO;
import com.mmc.oms.model.dto.CouponDTO;
import com.mmc.oms.model.qo.CouponInfoQO;
import com.mmc.oms.model.qo.CouponUserInfoQO;
import com.mmc.oms.model.qo.ProductCouponQO;
import com.mmc.oms.model.vo.CouponInfoActivityVO;
import com.mmc.oms.model.vo.CouponInfoVO;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * @Author small
 * @Date 2023/5/24 13:28
 * @Version 1.0
 */
public interface CouponBackService extends IService<CouponDO> {


    /**
     * 创建-优惠券
     * @param couponVO
     * @return
     */
    ResultBody saveCouponBackInfo(CouponInfoVO couponVO, MultipartFile file);

    /**
     * 创建-裂变优惠券
     * @param couponInfoActivityVO
     * @return
     */
    ResultBody saveActivityCouponInfo(CouponInfoActivityVO couponInfoActivityVO);


    /**
     * 查询分页列表-优惠券
     * @param couponInfoQO
     * @return
     */
    ResultBody pageCouponList(CouponInfoQO couponInfoQO);

    /**
     * 查询分页列表-裂变优惠券
     * @param couponInfoQO
     * @return
     */
    ResultBody pageActivityCouponList(CouponInfoQO couponInfoQO);

    /**
     * 裂变优惠券-下拉
     * @return
     */
    ResultBody getActivityCouponPullDown(Integer type);


    /**
     * 根据id修改优惠券发放数量
     * @param id
     * @param count
     * @return
     */
    ResultBody increaseCouponCount(Integer id,Integer count);


    /**
     * 根据id修改优惠卷状态
     * @param id
     * @return
     */
    ResultBody shutDown(Integer id);


    /**
     * 获取优惠券使用数据
     * @param id 优惠券id
     * @return
     */
    ResultBody couponViewData(Integer id);


    /**
     * 获取优惠卷明细列表
     * @param couponUserInfoQO
     * @return
     */
    ResultBody getCouponUserList(CouponUserInfoQO couponUserInfoQO);

    /**
     * 优惠卷明细列表导出
     * @param response
     * @param couponUserInfoQO
     * @throws IOException
     */
    void downloadCouponUserList(HttpServletResponse response, CouponUserInfoQO couponUserInfoQO) throws IOException;

    /**
     * 获取优惠卷详情
     * @param ids id
     * @return
     */
    List<CouponDTO> feignByIds(List<Integer> ids);


    /**
     * 根据id获取裂变优惠券详情
     * @param id
     * @return
     */
    CouponActivityDTO getCouponActivityById(Integer id);

    /**
     * 根据id获取裂变优惠券详情
     * @param id
     * @return
     */
    List<CouponActivityDTO> getCouponActivityList(List<Integer> id);

    /**
     * 扣减数量
     * @param id 优惠券id
     * @param num 数量
     * @param isLimited 是否限量
     */
    Boolean deduction(Integer id, Integer num, Boolean isLimited);


    /**
     * 批量更改优惠券状态
     */
    void overdueCouponTask();


    List<CouponDTO> feignGetCouponType(Integer type);

    ResultBody ordinaryActivities(ProductCouponQO productCouponQO);

    ResultBody fissionActivity(ProductCouponQO productCouponQO);
}
