package com.mmc.oms.model.vo;

import com.alibaba.fastjson.JSONObject;
import com.mmc.oms.common.MsgData;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.util.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @Author small
 * @Date 2023/5/24 16:13
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value = "com.mmc.csf.model.vo.WxSendMsgVO", description = "微信服务通知VO")
public class WxSendMsgVO implements Serializable {
    private static final long serialVersionUID = -2308646143286881148L;
    @ApiModelProperty(value = "用户id-仅适用云享飞客户端")
    private Integer userAccountId;
    @ApiModelProperty(value = "公众号的openId")
    private String openId;
    @ApiModelProperty(value = "unionId-全局通用")
    private String unionId;
    @ApiModelProperty(value = "模板id")
    @NotNull(message = "模板id不能为空")
    private String templemteId;
    @ApiModelProperty(value = "网页跳转连接")
    private String url;
    @ApiModelProperty(value = "小程序APPID")
    private String wxAppltAppId;
    @ApiModelProperty(value = "小程序跳转连接")
    private String appletPath;
    @ApiModelProperty(value = "标题")
    private MsgData title;
    @ApiModelProperty(value = "消息数组")
    private List<MsgData> data;
    @ApiModelProperty(value = "消息备注")
    private MsgData remark;

    public String buildMsgJson() {
        JSONObject obj = new JSONObject();
        obj.put("touser", this.openId);
        obj.put("template_id", this.templemteId);
        if (!StringUtils.isBlank(this.url)) {
            obj.put("url", this.url);
        }

        if (!StringUtils.isBlank(this.wxAppltAppId) && !StringUtils.isBlank(this.appletPath)) {
            JSONObject mini = new JSONObject();
            mini.put("appid", this.wxAppltAppId);
            mini.put("pagepath", this.appletPath);
            obj.put("miniprogram", mini);
        }
        JSONObject jd = new JSONObject();
        jd.put("first", this.convertMsg(title));
        if (!CollectionUtils.isEmpty(this.data)) {
            for (int i = 0; i < data.size(); i++) {
                String key = "keyword" + (i + 1);
                jd.put(key, this.convertMsg(data.get(i)));
            }
        }

        if (this.remark != null && !StringUtils.isBlank(this.remark.getValue())) {
            jd.put("remark", this.convertMsg(this.remark));
        }

        obj.put("data", jd);
        return obj.toJSONString();
    }

    public JSONObject convertMsg(MsgData msg) {
        JSONObject jb = new JSONObject();
        jb.put("value", msg.getValue());
        jb.put("color", msg.getColor());
        return jb;
    }

    public static void main(String[] args) {
        WxSendMsgVO ws = new WxSendMsgVO();
        ws.setOpenId("OPENID12345698979");
        ws.setTemplemteId("TEMPLETEID789465");
        ws.setUrl("http://baidu.com");
        ws.setWxAppltAppId("APPLETID123");
        ws.setAppletPath("pages-tx/jiafang/order/detail/index?taskId=123");
        List<MsgData> list = new ArrayList<MsgData>();
        MsgData m1 = new MsgData();
        m1.setValue("111");
        m1.setColor("#66699955");
        list.add(m1);

        MsgData m2 = new MsgData();
        m2.setValue("222");
        m2.setColor("#66699955");
        list.add(m2);
        ws.setData(list);

        MsgData title = new MsgData();
        title.setColor("gray");
        title.setValue("我的标题");

        ws.setTitle(title);

        String json = ws.buildMsgJson();
        System.out.println(json);
    }
}
