package com.mmc.oms.model.vo;

import com.mmc.oms.entity.OrderVcuDO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.util.CollectionUtils;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @Author small
 * @Date 2023/5/31 16:18
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value = "com.mmc.csf.model.vo.ReturnWareVO", description = "退换货类")
public class ReturnWareVO {
    @ApiModelProperty(value = "订单ID", required = true)
    @NotNull
    private Integer orderInfoId;

    @ApiModelProperty(value = "退还货方式：0邮寄 1门店地址 默认0 暂无门店", example = "0")
    @NotNull(message = "归还方式不能为空")
    private Integer renMethod;

    @ApiModelProperty(value = "门店id(退换货方式为门店归还时候必填)")
    private Integer repoInfoId;

    @ApiModelProperty(value = "还货-物流公司编码（还货方式为邮寄必填）")
    private String renExCode;
    @ApiModelProperty(value = "还货-物流单号（还货方式为邮寄必填）")
    private String renExNo;

    @ApiModelProperty(value = "设备状况:0无问题 1有问题")
    @NotNull(message = "退换货-地址不能为空")
    private Integer vcuSatus;
    @ApiModelProperty(value = "补充描述")
    private String remark;
    @ApiModelProperty(value = "图片集合")
    private List<String> imgs;
    @ApiModelProperty(value = "视频")
    private String videoUrl;

    public OrderVcuDO buildOrdeVcu() {
        return OrderVcuDO.builder().vcuSatus(this.vcuSatus).remark(this.remark)
                .imgs(CollectionUtils.isEmpty(this.imgs) ? null : String.join(",", this.imgs)).videoUrl(this.videoUrl)
                .orderInfoId(this.orderInfoId).build();
    }
}

