package com.mmc.oms.model.vo;

import com.mmc.oms.common.Confirm;
import com.mmc.oms.common.Query;
import com.mmc.oms.common.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * @Author small @Date 2023/5/26 10:54 @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
// @ApiModel(value = "com.mmc.csf.model.vo.MathOrderVO", description = "计算租金VO")
public class RentalOrderVO implements Serializable {

  private static final long serialVersionUID = -7517024869922103415L;

  @ApiModelProperty(value = "id")
  @NotNull(
      message = "订单id",
      groups = {Update.class, Query.class})
  private Integer id;

  @ApiModelProperty(value = "订单编号")
  private String orderNo;

  @ApiModelProperty(value = "商品id")
  private Integer wareInfoId;

  @ApiModelProperty(value = "商品编号")
  private String wareNo;

  @ApiModelProperty(value = "商品标题")
  private String wareTitle;

  @ApiModelProperty(value = "商品图片")
  private String wareImg;

  @ApiModelProperty(value = "购买用户id")
  private Integer repoAccountId;

  @ApiModelProperty(value = "购买用户uid")
  private String uid;

  @ApiModelProperty(value = "购买用户名称")
  private String buyerName;

  @ApiModelProperty(value = "购买用户手机号")
  private String buyerPhone;

  @ApiModelProperty(value = "购买用户地址")
  private String buyerAddress;

  @ApiModelProperty(value = "备注")
  private String remark;

  private String shutReason;
  private String payNo;
  private Date payTime;
  private Date sendWareTime;
  private Integer rcdCompanyId;

  @ApiModelProperty(value = "购买数量")
  @Min(value = 1)
  @NotNull(
      message = "商品数量不能为空",
      groups = {Confirm.class, Query.class})
  private Integer wareNum;

  @ApiModelProperty(value = "起租时间")
  @NotNull(
      message = "起租时间不能为空",
      groups = {Confirm.class, Query.class})
  private Date startDate;

  @ApiModelProperty(value = "结束时间")
  @NotNull(
      message = "结束时间不能为空",
      groups = {Confirm.class, Query.class})
  private Date endDate;

  @ApiModelProperty(value = "归还时间")
  @NotNull(
      message = "归还时间不能为空",
      groups = {Confirm.class, Query.class})
  private Date returnTime;

  @ApiModelProperty(value = "规格id")
  @NotNull(
      message = "规格id不能为null",
      groups = {Confirm.class, Query.class})
  private Integer specsId;

  @ApiModelProperty(value = "优惠券的id")
  private Integer couponId;
}
