package com.mmc.oms.model.vo;

import com.mmc.oms.common.Create;
import com.mmc.oms.common.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author small
 * @Date 2023/5/24 15:33
 * @Version 1.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class ProductSpecVO implements Serializable {
    private static final long serialVersionUID = -2681122778843398310L;
    @ApiModelProperty(value = "id")
    @NotNull(message = "修改时id不能为空", groups = {Update.class})
    private Integer id;
    @ApiModelProperty(value = "productSkuId")
    @NotNull(message = "修改时productSkuId不能为空", groups = {Create.class})
    private Integer productSkuId;
    @NotNull(message = "规格名称不能为空", groups = {Update.class, Create.class})
    @ApiModelProperty(value = "规格名称")
    private String specName;
    @NotNull(message = "规格图片不能为空", groups = {Update.class, Create.class})
    @ApiModelProperty(value = "规格图片")
    private String specImage;
    @NotNull(message = "料号不能为空", groups = {Update.class, Create.class})
    @ApiModelProperty(value = "料号")
    private String partNo;
    @ApiModelProperty(value = "版本描述")
    private String versionDesc;
    @ApiModelProperty(value = "价格配置信息")
    private ProductSpecCPQVO productSpecCPQVO;
}
