package com.mmc.oms.model.vo;

import com.mmc.oms.common.Freeze;
import com.mmc.oms.common.Page;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * @Author small
 * @Date 2023/6/1 14:05
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class OrderStatusVO {
    private static final long serialVersionUID = -3695743775258866831L;

    @ApiModelProperty(value = "订单状态")
    private Integer orderStatus;
    @ApiModelProperty(value = "账号id", hidden = true)
    private Integer userAccountId;

    @ApiModelProperty(value = "页码", example = "1")
    @NotNull(message = "页码不能为空", groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class, message = "pageNo不能少于1")
    private Integer pageNo;

    @ApiModelProperty(value = "每页显示数", example = "10")
    @NotNull(message = "每页显示数不能为空", groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class, message = "pageSize不能少于1")
    private Integer pageSize;

    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }
}
