package com.mmc.oms.model.vo;

import com.mmc.oms.entity.OrderReceiptDO;
import com.mmc.oms.model.dto.RepoInfoDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @Author small @Date 2023/5/26 11:14 @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
// @ApiModel(value = "com.mmc.csf.model.vo.OrderReceiptVO", description = "收货地址类")
public class OrderReceiptVO implements Serializable {
  private static final long serialVersionUID = -3695743775258866831L;

  @ApiModelProperty(value = "", hidden = true)
  private Integer id;

  @ApiModelProperty(value = "订单id", example = "1")
  private Integer orderInfoId;

  @ApiModelProperty(value = "收货方式：0邮寄 1门店地址", example = "0")
  private Integer receiptMethod;

  @ApiModelProperty(value = "收货人姓名", example = "xiao")
  private String takeName;

  @ApiModelProperty(value = "收货人手机号", example = "18923323223")
  private String takePhone;

  @ApiModelProperty(value = "收获区域", example = "广东省深圳市")
  private String region;

  @ApiModelProperty(value = "收获详细地址", example = "南山区XXXX")
  private String detailAddress;

  @ApiModelProperty(value = "门店名称", hidden = true)
  private String repoName;

  @ApiModelProperty(value = "门店地址", hidden = true)
  private String repoAddress;

  @ApiModelProperty(value = "预留手机号", hidden = true)
  private String bookPhone;

  @ApiModelProperty(value = "物流公司编码")
  private String sendExCode;

  @ApiModelProperty(value = "物流单号")
  private String sendExNo;

  public void buildAddress(RepoAddressDTO d) {
    this.takeName = d.getRealName();
    this.takePhone = d.getPhoneNum();
    this.region = d.getRegion();
    this.detailAddress = d.getDetailAddress();
  }

  public void buildAddress(RepoInfoDTO d, String bookPhone) {
    this.repoName = d.getRepoName();
    this.repoAddress = d.getRepoAddress();
    this.bookPhone = bookPhone;
  }

  public OrderReceiptDO buildOrderReceiptDO() {
    return OrderReceiptDO.builder()
        .orderInfoId(this.orderInfoId)
        .sendExCode(this.sendExCode)
        .sendExNo(this.sendExNo)
        .build();
  }
}
