package com.mmc.oms.model.vo;

import com.mmc.oms.common.Create;
import com.mmc.oms.common.Update;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

/**
 * @Author small
 * @Date 2023/5/24 15:26
 * @Version 1.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
//@ApiModel(value = "com.mmc.csf.mall.vo.MallGoodsAddVO", description = "机城商品新增VO")
public class MallGoodsAddVO implements Serializable {
    private static final long serialVersionUID = -6942710361131878887L;
    @ApiModelProperty(value = "商品类型  0:硬件产品 1：方案套餐")
    private Integer goodsType;
    @ApiModelProperty(value = "spuId")
    private Long spuId;
    @ApiModelProperty(value = "商品基本信息")
    private GoodsInfoVO goodsInfoVO;
    @ApiModelProperty(value = "商品图片")
    @NotEmpty(message = "商品图片不能为空", groups = {Create.class, Update.class})
    private List<GoodsImgVO> imgList;
    @ApiModelProperty(value = "商品详情VO")
    private GoodsDetailVO goodsDetailVO;
    @ApiModelProperty(value = "硬件产品对象")
    private List<ProductSkuVO> productSkuVO;
    @ApiModelProperty(value = "方案套餐")
    private List<PlanPackageVO> planPackageVO;
    @ApiModelProperty(value = "其他服务: 1:免费配送，2：专业飞手培训2日， 3：半年保修， 4：一年保修 ")
    private List<Integer> otherService;
    @ApiModelProperty(value = "推荐配件")
    private List<Integer> rcdId;
    @ApiModelProperty(value = "常见问题")
    private List<GoodsQaVO> question;
    @ApiModelProperty(value = "清单及配置信息")
    private GoodsConfigExportVO goodsConfigExport;
    @ApiModelProperty(value ="规格组合集合")
    private List<SpuValuesVO> spu;
    @ApiModelProperty(value = "加购商品")
    private List<AddOnGoodsVO> addOnGoods;
}
