package com.mmc.oms.model.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author small @Date 2023/5/26 11:28 @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class LeaseOrderVO implements Serializable {
  private static final long serialVersionUID = 3876353091071918771L;

  @ApiModelProperty(value = "订单编号", hidden = true)
  private String orderNo;

  @ApiModelProperty(value = "商品id", example = "1")
  private Integer wareInfoId;

  @ApiModelProperty(value = "商品编号", example = "mmcKu001")
  private String wareNo;

  @ApiModelProperty(value = "商品标题", example = "入云龙")
  private String wareTitle;

  @ApiModelProperty(
      value = "商品图片",
      example =
          "https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/4edf7f84-1586-4f33-ad79-c37b9f31cbce.jpg")
  private String wareImg;

  @ApiModelProperty(
          value = "商品描述",
          example ="新一代无人机")
  private String wareDescription;

  @ApiModelProperty(value = "套餐sku id", hidden = true)
  private Integer skuInfoId;

  @ApiModelProperty(value = "套餐sku名称", hidden = true)
  private String skuTitle;

  @ApiModelProperty(value = "租赁的用户id", example = "1" ,hidden = true)
  private Integer repoAccountId;

  @ApiModelProperty(value = "租赁的用户uid", example = "UID008123",hidden = true)
  private String uid;

  @ApiModelProperty(value = "租赁的用户名称", example = "xiaoXiao",hidden = true)
  private String buyerName;

  @ApiModelProperty(value = "租赁的用户手机", example = "18923131232",hidden = true)
  private String buyerPhone;

  @ApiModelProperty(value = "单价 元/天", hidden = true)
  private BigDecimal unitPrice;

  @ApiModelProperty(value = "租赁商品数量", example = "3")
  private Integer wareNum;

  @ApiModelProperty(value = "应付款金额", example = "120")
  private BigDecimal shouldPay;

  @ApiModelProperty(value = "实付款金额", example = "30")
  private BigDecimal actualPay;

  @ApiModelProperty(value = "订单类型 0租赁 100购买", hidden = true)
  private Integer orderType;

  @ApiModelProperty(value = "押金 默认0", example = "0")
  private BigDecimal deposit;

  @ApiModelProperty(value = "租金总金额", example = "90")
  private BigDecimal rentPrice;

  @ApiModelProperty(value = "租赁开始日期", example = "2023-05-20")
  @JsonFormat(locale = "zh", timezone = "CMT+8", pattern = "yyyy-MM-dd")
  private Date startDate;

  @JsonFormat(locale = "zh", timezone = "CMT+8", pattern = "yyyy-MM-dd")
  @ApiModelProperty(value = "租赁结束日期", example = "2023-05-27")
  private Date endDate;

  @JsonFormat(locale = "zh", timezone = "CMT+8", pattern = "yyyy-MM-dd")
  @ApiModelProperty(value = "租赁归还日期", example = "2023-05-28")
  private Date returnDate;

  @ApiModelProperty(value = "付款天数", hidden = true)
  private Integer payDay;

  @ApiModelProperty(value = "减库方式---0:买家拍下减库存 1:卖家付款减库存", hidden = true)
  private Integer exWare;

  @ApiModelProperty(value = "交易状态： 查订单状态字典")
  private String tranStatus;

  @ApiModelProperty(value = "用户备注", example = "包装需要完好")
  private String remark;

  @ApiModelProperty(value = "")
  private Integer rcdCompanyId;

  @ApiModelProperty(value = "添加时间", hidden = true)
  private Date createTime;

  @ApiModelProperty(value = "收获地址")
  private OrderReceiptVO orderReceipt;

  @ApiModelProperty(value = "优惠券id", example = "221")
  private Integer couponId;

  @ApiModelProperty(value = "规格id", example = "1")
  private Integer specsId;
}
