package com.mmc.oms.model.vo;

import com.mmc.oms.common.Create;
import com.mmc.oms.common.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @Author small
 * @Date 2023/5/24 15:32
 * @Version 1.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class GoodsAddVO implements Serializable {
    private static final long serialVersionUID = 7041502536618388167L;
    @ApiModelProperty(value = "id")
    @NotNull(message = "修改时id不能为空", groups = {Update.class})
    private Integer id;
    @ApiModelProperty(value = "商品图片")
    @NotEmpty(message = "主图不能为空", groups = {Update.class, Create.class})
    private List<GoodsImgVO> images;
    @ApiModelProperty(value = "商品视频")
    private String goodsVideo;
    @ApiModelProperty(value = "商品名称")
    @NotNull(message = "商品名称不能为空", groups = {Update.class, Create.class})
    private String goodsName;
    @ApiModelProperty(value = "商品详情")
    private GoodsDetailVO goodsDetailVO;
    @ApiModelProperty(value = "所属目录")
    @NotNull(message = "所属目录不能为空", groups = {Update.class, Create.class})
    private Integer sortTypeId;
    @ApiModelProperty(value = "一级分类id")
    @NotNull(message = "分类不能为空", groups = {Update.class, Create.class})
    private Integer masterTypeId;
    @ApiModelProperty(value = "二级分类id")
    private Integer slaveTypeId;
    @ApiModelProperty(value = "商品标签")
    private String tag;
    @ApiModelProperty(value = "商品状态 0:下架 1:上架")
    private Integer shelfStatus;
    @ApiModelProperty(value = "规格信息")
    private List<GoodsSpecVO> GoodsSpecVO;
    @ApiModelProperty(value = "其他服务: 1:免费配送，2：专业飞手培训2日， 3：半年保修， 4：一年保修 ")
    private List<Integer> otherService;
    @ApiModelProperty(value = "云享飞服务id")
    private Integer shareFlyServiceId;
    @ApiModelProperty(value = "云仓配件id")
    private Integer repoId;
    @ApiModelProperty(value = "常见问题")
    private List<GoodsQaVO> question;
}
