package com.mmc.oms.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.hibernate.validator.constraints.Range;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author small
 * @Date 2023/5/24 14:47
 * @Version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
//@ApiModel(value="CouponUserVO对象", description="优惠券记录表修改VO")
public class CouponUserVO implements Serializable {

    private static final long serialVersionUID=1L;

    @ApiModelProperty(value = "用户优惠券id",required = true)
    private Integer id;

    @ApiModelProperty(value = "订单id",required = true)
    private Long cid;

    @ApiModelProperty(value = "订单编码",required = true)
    private String orderNo;

    @ApiModelProperty(value = "状态（0：未使用，1：已使用, 2:已失效，3:已转赠 4:使用中）",required = true)
    @Range(min = 1, max = 4, message = "请选择优惠券类型")
    private Integer status;

    @ApiModelProperty(value = "剩余余额")
    private BigDecimal remainingBalance;


    /**
     * 开始
     * 转换使用
     */
    @ApiModelProperty(value = "使用金额")
    private BigDecimal useAmount;
    @ApiModelProperty("优惠券类型")
    private Integer couponType;
    @ApiModelProperty("优惠券使用类型")
    private Integer useType;
    /**
     * 结束
     */
    /**
     * 使用时间
     */
    private Date orderUsageTime;

}
