package com.mmc.oms.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.Max;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author small
 * @Date 2023/5/24 14:00
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
//@EqualsAndHashCode(callSuper = false)
//@Accessors(chain = true)
//@ApiModel(value="CouponVO对象", description="优惠券表添加/修改VO")
public class CouponInfoVO implements Serializable {

    private static final long serialVersionUID=1L;

    @ApiModelProperty(value = "优惠券名称", required = true)
    @NotBlank(message = "请填写优惠券名称")
    @Length(max = 64, message = "优惠券名称长度不能超过64个字符")
    private String couponName;

    @ApiModelProperty(value = "兑换的优惠券面值", required = true)
    @NotNull(message = "请填写优惠券兑换的优惠券面值")
    @DecimalMax(value = "99999.99", message = "优惠券面值不能大于99999.99")
    private BigDecimal couponMoney;

    @ApiModelProperty(value = "优惠券折扣")
    private BigDecimal couponDiscount;

    @ApiModelProperty(value = "是否限量, false否， true是", required = true)
    @NotNull(message = "请设置是否限量")
    private Boolean isLimited;

    @ApiModelProperty(value = "发放总数")
    private Integer couponTotal;

    @ApiModelProperty(value = "优惠券类型 1打折卷, 2减免券 3无门槛",required = true)
    @Range(min = 1, max = 3, message = "请选择优惠券类型")
    private Integer couponType;

    @ApiModelProperty(value = "优惠券使用类型 1vip,2品牌券",required = true)
    @Range(min = 1, max = 2, message = "请选择优惠券使用类型")
    private Integer useType;

    @ApiModelProperty(value = "所属 品牌范围id  例：5,9... ", required = true)
    private String primaryKey;

    @ApiModelProperty(value = "最低消费",required = true)
    private BigDecimal minPrice;

    @ApiModelProperty(value = "有效期使用时间方式：0 固定使用时间, 1领取当日起 2领取次日起", required = true)
    @NotNull(message = "请选择领取是否限时")
    private Integer isFixedTime;

    @ApiModelProperty(value = "可使用时间范围 开始时间 yyyy-MM-dd HH:mm:ss")
    private Date useStartTime;

    @ApiModelProperty(value = "可使用时间范围 结束时间 yyyy-MM-dd HH:mm:ss")
    private Date useEndTime;

    @ApiModelProperty(value = "可使用时间 天数")
    @Max(value = 999, message = "天数不能超过999天")
    private Integer couponDay;

    @ApiModelProperty(value = "优惠券类型 1 手动领取 2 系统发放 3 批量导入用户",required = true)
    @Range(min = 1, max = 3, message = "请选择优惠券领取方式")
    private Integer getType;

    @ApiModelProperty(value = "用户标签")
    private Integer userTag;

    @ApiModelProperty(value = "每人限制领取张数")
    private Integer restrictedAccess;

    @ApiModelProperty(value = "最多优惠")
    private BigDecimal preferentialLimit;

    @ApiModelProperty(value = "是否单次核销 false单次核销 true多次核销",required = true)
    private Boolean verificationType;

    @ApiModelProperty(value = "是否单次核销 0单次核销 1多次核销")
    private String fileUrl;
}
