package com.mmc.oms.model.vo;

import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @Author small
 * @Date 2023/5/24 16:09
 * @Version 1.0
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
//@ApiModel(value = "com.mmc.csf.model.vo.AppletMsgVO", description = "小程序订阅消息VO")
public class AppletMsgVO implements Serializable {
    private static final long serialVersionUID = 2124104608303700492L;
    @ApiModelProperty(value = "openid")
    @NotBlank
    private String touser;
    @ApiModelProperty(value = "模板ID")
    @NotBlank
    private String template_id;
    @ApiModelProperty(value = "点击模板卡片后的跳转页面，仅限本小程序内的页面。支持带参数,（示例index?foo=bar）。该字段不填则模板无跳转。")
    private String page;
    @ApiModelProperty(value = "模板内容")
    private JSONObject data;
    @ApiModelProperty(value = "跳转小程序类型：developer为开发版；trial为体验版；formal为正式版；默认为正式版")
    private String miniprogram_state;
    @ApiModelProperty(value = "默认为zh_CN")
    private String lang;
}
