package com.mmc.oms.model.qo;

import com.mmc.oms.common.Page;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @Author small @Date 2023/5/27 15:52 @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
// @ApiModel(value = "com.mmc.csf.model.qo.OrderInfoQO", description = "订单QO")
public class OrderInfoQO implements Serializable {
  private static final long serialVersionUID = -3503119623575892302L;

  @ApiModelProperty(value = "用户ID", hidden = true)
  private Integer repoAccountId;

  @ApiModelProperty(value = "关键字")
  private String keyword;

  @ApiModelProperty(value = "买家名称")
  private String buyerName;

  @ApiModelProperty(value = "订单编号")
  private String orderNo;

  @ApiModelProperty(value = "商品编号")
  private String wareNo;

  @ApiModelProperty(value = "商品名称")
  private String wareTitle;

  @ApiModelProperty(value = "订单状态：查字典")
  private String tranStatus;

  @ApiModelProperty(value = "开始时间")
  private String startTime;

  @ApiModelProperty(value = "结束时间")
  private String endTime;

  @ApiModelProperty(value = "用户ID", hidden = true)
  private List<Integer> userIds;

  @ApiModelProperty(value = "单位ID", hidden = true)
  private List<Integer> companys;

  @ApiModelProperty(value = "页码", required = true)
  @NotNull(
      message = "页码不能为空",
      groups = {Page.class})
  @Min(value = 1, groups = Page.class)
  private Integer pageNo;

  @ApiModelProperty(value = "每页显示数", required = true)
  @NotNull(
      message = "每页显示数不能为空",
      groups = {Page.class})
  @Min(value = 1, groups = Page.class)
  private Integer pageSize;

  public void buildCurrentPage() {
    this.pageNo = (pageNo - 1) * pageSize;
  }
}
