package com.mmc.oms.model.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @Author small @Date 2023/5/26 13:20 @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
// @ApiModel(value = "com.mmc.csf.model.dto.WareInfoFirstPageDTO", description = "商品首页DTO")
public class WareInfoFirstPageDTO implements Serializable {
  private static final long serialVersionUID = -220701135688609035L;

  @ApiModelProperty(value = "ID")
  private Integer id;

  @ApiModelProperty(value = "商品编号")
  private String wareNo;

  @ApiModelProperty(value = "商品标题")
  private String wareTitle;

  @ApiModelProperty(value = "商品类型ID")
  private Integer wareTypeId;

  @ApiModelProperty(value = "商品状态")
  private Integer wareStatus;

  @ApiModelProperty(value = "最小押金")
  private BigDecimal minDeposit;

  @ApiModelProperty(value = "最小租金")
  private BigDecimal minRent;

  @ApiModelProperty(value = "标签集合")
  private List<String> tags;

  @ApiModelProperty(value = "商品图片集合")
  private List<WareImgDTO> wareImgs;
  //	@ApiModelProperty(value = "商品视频集合")
  //	private List<WareVideoDTO> wareVideos;
  @ApiModelProperty(value = "商品活动对象")
  private WarePropDTO warePropDTO;
}
