package com.mmc.oms.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author small
 * @Date 2023/5/24 15:03
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value = "com.mmc.csf.model.dto.WagTermDetailDTO", description = "任务工资信息DTO")
public class WagTermDetailDTO implements Serializable {
    private static final long serialVersionUID = 6088946395006027466L;
    @ApiModelProperty(value = "ID")
    private Integer id;
    @ApiModelProperty(value = "工资日期")
    private Date costDate;
    @ApiModelProperty(value = "工资(元/日)")
    private BigDecimal wagPrice;
    @ApiModelProperty(value = "补贴(元/日)")
    private BigDecimal sudyPrice;
    @ApiModelProperty(value = "出差租房补贴(元/日)")
    private BigDecimal rentHousePrice;
    @ApiModelProperty(value = "出差交通补贴(元/日)")
    private BigDecimal trafficPrice;
    @ApiModelProperty(value = "高温补贴(元/日)")
    private BigDecimal hotPrice;
    @ApiModelProperty(value = "飞手人数")
    private Integer flyerNum;
    @ApiModelProperty(value = "支付比例")
    private BigDecimal payPersent;
    @ApiModelProperty(value = "应结工资")
    private BigDecimal shouldPay;
    @ApiModelProperty(value = "补贴合计-单价（不计算人数）")
    private BigDecimal daySudyUnit;

    public void defaultValue() {
        if (this.wagPrice == null) {
            this.wagPrice = BigDecimal.ZERO;
        }

        if (this.sudyPrice == null) {
            this.sudyPrice = BigDecimal.ZERO;
        }

        if (this.rentHousePrice == null) {
            this.rentHousePrice = BigDecimal.ZERO;
        }

        if (this.trafficPrice == null) {
            this.trafficPrice = BigDecimal.ZERO;
        }

        if (this.wagPrice == null) {
            this.wagPrice = BigDecimal.ZERO;
        }

        if (this.payPersent == null) {
            this.payPersent = BigDecimal.ZERO;
        }

        if (this.flyerNum == null) {
            this.flyerNum = 0;
        }
    }

}
