package com.mmc.oms.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author small
 * @Date 2023/5/24 14:56
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value = "com.mmc.csf.model.dto.UserAccountDTO", description = "用户信息DTO")
public class UserAccountDTO implements Serializable {
    private static final long serialVersionUID = -3760693134872196985L;
    @ApiModelProperty(value = "用户ID")
    private Integer id;
    @ApiModelProperty(value = "UID")
    private String uid;
    @ApiModelProperty(value = "账号")
    private String accountNo;
    @ApiModelProperty(value = "密码")
    private String passWord;
    @ApiModelProperty(value = "昵称")
    private String nickName;
    @ApiModelProperty(value = "姓名")
    private String userName;
    @ApiModelProperty(value = "身份证号码")
    private String idNumber;
    @ApiModelProperty(value = "电话号码")
    private String phoneNum;
    @ApiModelProperty(value = "性别：0未知 1男 2女 ")
    private Integer userSex;
    @ApiModelProperty(value = "常住地址")
    private String resAddres;
    private Integer realAuthStatus;
    @ApiModelProperty(value = "常住地址-经度")
    private String longitude;
    @ApiModelProperty(value = "常住地址-纬度")
    private String latitude;
    @ApiModelProperty(value = "是否企业用户：0否 1是")
    private Integer entUser;
    @ApiModelProperty(value = "是否渠道用户：0否 1是")
    private Integer channelUser;
    @ApiModelProperty(value = "备注")
    private String remark;
    @ApiModelProperty(value = "账号类型：0神行太保平台账号 ; 100云享飞-客户端; 101云享飞-飞手端; 102云享飞-云仓端")
    private Integer accountType;
    @ApiModelProperty(value = "账号状态：0禁用 1可用")
    private Integer accountStatus;
    @ApiModelProperty(value = "角色信息")
    private RoleInfoDTO roleInfo;
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
    @ApiModelProperty(value = "身份证正面照")
    private String frontIdImg;
    @ApiModelProperty(value = "身份证反面照")
    private String backIdImg;
    @ApiModelProperty(value = "邮箱")
    private String email;
    @ApiModelProperty(value = "单位信息")
    private CompanySimpleDTO companyInfo;
    private Integer rcdCompanyId;
    @ApiModelProperty(value = "渠道等级")
    private String channelLevel;
    @ApiModelProperty(value = "法大大企业认证状态")
    private Integer entVerifyStatus;

    public UserAccountDTO(Integer id, String uid, String nickName) {
        this.id = id;
        this.uid = uid;
        this.nickName = nickName;
    }
}
