package com.mmc.oms.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author small
 * @Date 2023/5/31 16:41
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "com.mmc.csf.model.dto.ShareOrderDTO", description = "共享设备订单DTO")
public class ShareOrderDTO implements Serializable {
    private static final long serialVersionUID = -1395178773843809078L;
    @ApiModelProperty(value = "id")
    private Integer id;
    @ApiModelProperty(value = "订单编号")
    private String orderNo;
    @ApiModelProperty(value = "用户id")
    private Integer repoAccountId;
    @ApiModelProperty(value = "用户uid")
    private String uid;
    @ApiModelProperty(value = "用户手机号")
    private String phoneNum;
    @ApiModelProperty(value = "设备品牌")
    private String deviceBrand;
    @ApiModelProperty(value = "地区")
    private String region;
    @ApiModelProperty(value = "状态:查字典")
    private Integer sdStatus;
    @ApiModelProperty(value = "设备ID")
    private String deviceCode;
    @ApiModelProperty(value = "设备型号")
    private String deviceModel;
    @ApiModelProperty(value = "用户备注")
    private String remark;
    @ApiModelProperty(value = "平台备注")
    private String pfRemark;
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
    @ApiModelProperty(value = "修改人ID", hidden = true)
    private Integer updateUser;
    @ApiModelProperty(value = "操作人-名字")
    private String opName;
    @ApiModelProperty(value = "操作人-账号")
    private String opNo;

}
