package com.mmc.oms.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author small
 * @Date 2023/5/26 11:15
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value = "com.mmc.csf.model.dto.RepoInfoDTO", description = "仓库/门店DTO")
public class RepoInfoDTO implements Serializable {
    private static final long serialVersionUID = 8002261035352227237L;
    @ApiModelProperty(value = "ID")
    private Integer id;
    @ApiModelProperty(value = "仓库名称")
    private String repoName;
    @ApiModelProperty(value = "仓库编号")
    private String repoNo;
    @ApiModelProperty(value = "仓库地址")
    private String repoAddress;
    @ApiModelProperty(value = "经度")
    private BigDecimal lon;
    @ApiModelProperty(value = "纬度")
    private BigDecimal lat;
    @ApiModelProperty(value = "仓库营业时间")
    private String repoBusinessHours;
    @ApiModelProperty(value = "管理员Id")
    private Integer userAccountId;
    @ApiModelProperty(value = "管理员账号")
    private String accountNo;
    @ApiModelProperty(value = "管理员姓名")
    private String userName;
    @ApiModelProperty(value = "管理员手机号")
    private String phoneNum;
    @ApiModelProperty(value = "仓库库存")
    private Integer repoInventory;
    @ApiModelProperty(value = "是否删除")
    private Integer deleted;
    @ApiModelProperty(value = "生成时间")
    private Date createTime;
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
    @ApiModelProperty(value = "设备个数")
    private Integer deviceNum;

}
