package com.mmc.oms.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @Author small
 * @Date 2023/5/24 15:01
 * @Version 1.0
 */
@Data
//@ApiModel(value="OrderTaskSonDTO", description="云享飞订单-子任务表")
@AllArgsConstructor
@NoArgsConstructor
public class OrderTaskSonDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    private Integer id;

    @ApiModelProperty(value = "0为主任务")
    private Integer parentId;

    @ApiModelProperty(value = "客户ID")
    private Integer userAccountId;

    @ApiModelProperty(value = "运营人员ID（负责这个order的运营人员id")
    private Integer userOperateId;

    @ApiModelProperty(value = "订单编号")
    private String orderNo;

    @ApiModelProperty(value = "订单名称")
    private String orderName;

    @ApiModelProperty(value = "订单总金额")
    private BigDecimal orderAmt;

    @ApiModelProperty(value = "订单金额中的现金金额")
    private BigDecimal cashAmt;

    @ApiModelProperty(value = "订单金额中的信用金额")
    private BigDecimal creditAmt;

    @ApiModelProperty(value = "任务飞行地址")
    private String taskAddress;

    @ApiModelProperty(value = "基本信息")
    private String basicInfo;

    @ApiModelProperty(value = "服务开始时间")
    private LocalDateTime startTime;

    @ApiModelProperty(value = "服务结束时间")
    private LocalDateTime endTime;

    @ApiModelProperty(value = "实际服务开始时间")
    private LocalDateTime acStartTime;

    @ApiModelProperty(value = "实际服务结束时间")
    private LocalDateTime acEndTime;

    @ApiModelProperty(value = "0下单初始化(待分配运营）->	100已分配运营（待需求确认）->	200已经需求确认(待订单确认)->	300已订单确认（待预支付）->	400已预支付(调度中)->	500飞手已接单(待抵达现场)->	525飞手已抵达(待开始作业)->	550已开始作业(作业中)->	575飞手已完成作业(待平台确认作业完成)->	600平台已确认作业完成(待验收结算)->	700验收通过->	900订单关闭")
    private Integer orderStatus;

    @ApiModelProperty(value = "评价状态：0未评价 1已评价")
    private Integer evaluateStatus;

    private LocalDateTime createTime;

    private LocalDateTime updateTime;

    @ApiModelProperty(value = "服务项ID")
    private Integer inspectionId;

    @ApiModelProperty(value = "服务名称")
    private String inspectionName;

    @ApiModelProperty(value = "最近一次操作信息")
    private String lastMsg;

    @ApiModelProperty(value = "任务地址经度")
    private BigDecimal lon;

    @ApiModelProperty(value = "任务地址纬度")
    private BigDecimal lat;

    @ApiModelProperty(value = "订单关闭原因")
    private String shutReason;

    @ApiModelProperty(value = "是否营销数据（假数据）：0:否 1:是")
    private Boolean isDummy;

    @ApiModelProperty(value = "平台备注")
    private String pfRemark;

    @ApiModelProperty(value = "飞手类型（0个人飞手 1飞手机构）")
    private Integer flyerType;

    @ApiModelProperty(value = "任务飞手人数")
    private Integer flyerNum;

    @ApiModelProperty(value = "0:隐藏 1:显示(隐藏后飞手端不显示，不参与抢单)")
    private Integer display;

    @ApiModelProperty(value = "飞手评价：0未评价 1已评价")
    private Integer flyerEval;

    @ApiModelProperty(value = "是否进行过催单 0：未通知 1：已通知")
    private Integer isUrge;

    @ApiModelProperty(value = "订单类型：0普通订单，1推荐订单，2加急单")
    private Integer orderType;

    @ApiModelProperty(value = "需求确认备注")
    private String cmdRemark;

    @ApiModelProperty(value = "飞手抢单开始时间")
    private LocalDateTime flyerStartTime;

    @ApiModelProperty(value = "飞手抢单结束时间")
    private LocalDateTime flyerEndTime;

    @ApiModelProperty(value = "推荐机构")
    private Integer rcdCompanyId;
}

