package com.mmc.oms.model.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * @Author small
 * @Date 2023/6/1 14:28
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class OrderStatusDTO {
    private static final long serialVersionUID = 6544149196885009444L;
    @ApiModelProperty(value = "订单id")
    private Integer id;

    @ApiModelProperty(value = "订单编号")
    private String orderNo;

    @ApiModelProperty(value = "商品标题")
    private String wareTitle;

    @ApiModelProperty(value = "商品图片")
    private String wareImg;

    @ApiModelProperty(value = "实际付款")
    private BigDecimal actualPay;

    @ApiModelProperty(value = "订单描述")
    private String wareDescription;

    @ApiModelProperty(value = "订单状态编号")
    private Integer tranStatus;

    @ApiModelProperty(value = "等待状态")
    private String waiting;

    @ApiModelProperty(value = "当前状态")
    private String doing;

    @ApiModelProperty(value = "订单状态")
    private String leaseOrderStatus;
}
