package com.mmc.oms.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author small
 * @Date 2023/5/24 14:46
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value = "com.mmc.csf.mall.dto.OrderCouponDTO", description = "订单优惠券使用")
public class OrderCouponDTO implements Serializable {
    private static final long serialVersionUID = 6681933441428005418L;
    @ApiModelProperty("id")
    private Integer id;
    @ApiModelProperty("订单id")
    private Long orderId;
    @ApiModelProperty("用户优惠券id")
    private Integer couponUserId;
    @ApiModelProperty("优惠券类型")
    private Integer couponType;
    @ApiModelProperty("优惠券使用类型")
    private Integer useType;
    @ApiModelProperty("优惠券使用金额")
    private BigDecimal useAmount;
    @ApiModelProperty("使用时间")
    private Date createTime;
    @ApiModelProperty("优惠券简称")
    private String couponName;
}

