package com.mmc.oms.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.mmc.oms.common.CouponConstants;
import com.mmc.oms.model.dto.CouponUserDTO;
import com.mmc.oms.model.dto.CouponUserOrderDTO;
import com.mmc.oms.model.vo.CouponUserExchangeVO;
import com.mmc.oms.model.vo.CouponUserVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import lombok.experimental.Tolerate;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author small
 * @Date 2023/5/24 14:54
 * @Version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("coupon_user")
//@ApiModel(value = "CouponUser对象", description = "用户优惠券记录表")
public class CouponUserDO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "id")
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "优惠券id")
    private Integer couponId;


    @ApiModelProperty(value = "领取人id")
    private Integer uid;

    @ApiModelProperty(value = "领取人uuid")
    private String uuid;
    @ApiModelProperty(value = "领取人手机号码")
    private String userPhone;

    @ApiModelProperty(value = "优惠券名称")
    private String couponName;

    /**
     * @see com.mmc.csf.userpay.constants.CouponConstants
     */
    @ApiModelProperty(value = "优惠券类型 1打折券, 2减免券 3无门槛")
    private Integer couponType;


    /**
     * @see com.mmc.csf.userpay.constants.CouponConstants
     */
    @ApiModelProperty(value = "优惠券使用类型 1vip券, 2品牌券")
    private Integer useType;

    @ApiModelProperty(value = "优惠券的面值")
    private BigDecimal couponMoney;

    @ApiModelProperty(value = "最低消费")
    private BigDecimal minPrice;

    @ApiModelProperty(value = "优惠券的折扣")
    private BigDecimal couponDiscount;

    @ApiModelProperty(value = "剩余余额")
    private BigDecimal remainingBalance;

    /**
     * @see com.mmc.csf.userpay.constants.CouponConstants
     */
    @ApiModelProperty(value = "获取方式: 用户领取receive,  后台发放send, 赠送presented, 获赠acquire,积分兑换exchange")
    private String gainType;

    /**
     * @see com.mmc.csf.userpay.constants.CouponConstants
     */
    @ApiModelProperty(value = "状态（0：未使用,1：已使用, 2:已失效,3:已转赠,4:使用中）")
    private Integer status;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(value = "开始使用时间")
    private Date startTime;

    @ApiModelProperty(value = "过期时间")
    private Date endTime;

    @ApiModelProperty(value = "使用时间")
    private Date useTime;

    @ApiModelProperty(value = "所属品牌id")
    private String primaryKey;

    @ApiModelProperty(value = "兑换比例")
    private String conversionRatio;

    @ApiModelProperty(value = "转赠人uid")
    private String transferorUid;

    @ApiModelProperty(value = "获赠人uid")
    private String receiveUid;

    @ApiModelProperty(value = "转赠时间")
    private Date transferorTime;

    @ApiModelProperty(value = "是否多次核销 0单次核销 1多次核销")
    private Boolean verificationType;

    @ApiModelProperty(value = "最多优惠")
    private BigDecimal preferentialLimit;

    public CouponUserDTO bilIdCouponDTO() {
        return CouponUserDTO.builder().id(this.id).couponId(this.couponId).uid(this.uid)
                .userPhone(this.userPhone).couponName(this.couponName).couponType(this.couponType).useType(this.useType)
                .couponMoney(this.couponMoney).minPrice(this.minPrice).couponDiscount(this.couponDiscount)
                .remainingBalance(this.remainingBalance).gainType(this.gainType).status(this.status)
                .createTime(this.createTime).updateTime(this.updateTime).startTime(this.startTime)
                .endTime(this.endTime).useTime(this.useTime).primaryKey(this.primaryKey)
                .conversionRatio(this.conversionRatio).transferorUid(this.transferorUid).receiveUid(this.receiveUid)
                .transferorTime(this.transferorTime).verificationType(this.verificationType)
                .preferentialLimit(this.preferentialLimit).build();
    }


    public CouponUserOrderDTO buildCouponUserOrderDTO() {
        return CouponUserOrderDTO.builder().id(this.id).couponId(this.couponId).uid(this.uid)
                .userPhone(this.userPhone).couponName(this.couponName).couponType(this.couponType).useType(this.useType)
                .couponMoney(this.couponMoney).minPrice(this.minPrice).couponDiscount(this.couponDiscount)
                .remainingBalance(this.remainingBalance).gainType(this.gainType).status(this.status)
                .createTime(this.createTime).startTime(this.startTime).endTime(this.endTime).useTime(this.useTime)
                .primaryKey(this.primaryKey).verificationType(this.verificationType)
                .preferentialLimit(this.preferentialLimit).validStr("unusable").build();
    }

    @Tolerate
    public CouponUserDO(CouponUserVO couponUserVO) {
        this.id = couponUserVO.getId();
        this.status = couponUserVO.getStatus();
        this.remainingBalance = couponUserVO.getRemainingBalance();
    }

    @Tolerate
    public CouponUserDO(CouponUserExchangeVO couponUserExchangeVO) {
        this.uid = couponUserExchangeVO.getUid();
        this.uuid = couponUserExchangeVO.getUuid();
        this.userPhone = couponUserExchangeVO.getUserPhone();
        this.couponName = couponUserExchangeVO.getCouponName();
        this.couponMoney = couponUserExchangeVO.getCouponMoney();
        this.conversionRatio = couponUserExchangeVO.getConversionRatio();
    }

    @Tolerate
    public CouponUserDO(CouponDO couponDO) {
        this.couponId = couponDO.getId();
        this.couponName = couponDO.getCouponName();
        this.couponType = couponDO.getCouponType();
        this.useType = couponDO.getUseType();
        this.couponMoney = couponDO.getCouponMoney();
        this.minPrice = couponDO.getMinPrice();
        this.couponDiscount = couponDO.getCouponDiscount();
        this.status = CouponConstants.STORE_COUPON_USER_STATUS_USABLE;
        this.primaryKey = couponDO.getPrimaryKey();
        this.startTime = couponDO.getUseStartTime();
        this.endTime = couponDO.getUseEndTime();
        this.verificationType = couponDO.getVerificationType();
        this.preferentialLimit = couponDO.getPreferentialLimit();
    }
}
